package org.apache.maven.coreit;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import org.apache.maven.eventspy.AbstractEventSpy;

public class ItSpy
    extends AbstractEventSpy
{

    private PrintWriter writer;

    public void init( Context context )
        throws Exception
    {
        File logFile = new File( context.getData().get( "workingDirectory" ).toString(), "target/spy.log" );
        logFile.getParentFile().mkdirs();
        writer = new PrintWriter( new OutputStreamWriter( new FileOutputStream( logFile ), "UTF-8" ) );
        writer.println( "init" );
    }

    public void onEvent( Object event )
        throws Exception
    {
        writer.println( "event: " + event.getClass().getName() );
    }

    public void close()
        throws Exception
    {
        if ( writer != null )
        {
            writer.println( "close" );
            writer.close();
            writer = null;
        }
    }

}
