/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.BlockEncoder;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;

public class Rot13CypherTestUtil {
    private static final int ENCODING_OFFSET = 7;
    private static final int ENCODING_ROTATION = 13;

    public static byte[] encode(DataInput bytesInput, int length) throws IOException {
        byte[] encodedBytes = new byte[length + 7];
        for (int i = 0; i < length; ++i) {
            encodedBytes[i + 7] = (byte)(bytesInput.readByte() + 13);
        }
        return encodedBytes;
    }

    public static byte[] decode(DataInput bytesInput, long length) throws IOException {
        bytesInput.skipBytes(7L);
        byte[] decodedBytes = new byte[Math.toIntExact(length -= 7L)];
        int i = 0;
        while ((long)i < length) {
            decodedBytes[i] = (byte)(bytesInput.readByte() - 13);
            ++i;
        }
        return decodedBytes;
    }

    public static BlockEncoder getBlockEncoder() {
        return (blockBytes, length) -> {
            final byte[] encodedBytes = Rot13CypherTestUtil.encode(blockBytes, Math.toIntExact(length));
            return new BlockEncoder.WritableBytes(){

                public long size() {
                    return encodedBytes.length;
                }

                public void writeTo(DataOutput dataOutput) throws IOException {
                    dataOutput.writeBytes(encodedBytes, 0, encodedBytes.length);
                }
            };
        };
    }

    public static BlockDecoder getBlockDecoder() {
        return (blockBytes, length) -> new BytesRef(Rot13CypherTestUtil.decode(blockBytes, length));
    }
}

