/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public abstract class BaseLiveDocsFormatTestCase
extends LuceneTestCase {
    private Codec savedCodec;

    protected abstract Codec getCodec();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.savedCodec = Codec.getDefault();
        Codec.setDefault((Codec)this.getCodec());
    }

    @Override
    public void tearDown() throws Exception {
        Codec.setDefault((Codec)this.savedCodec);
        super.tearDown();
    }

    public void testDenseLiveDocs() throws IOException {
        int maxDoc = TestUtil.nextInt(BaseLiveDocsFormatTestCase.random(), 3, 1000);
        this.testSerialization(maxDoc, maxDoc - 1, false);
        this.testSerialization(maxDoc, maxDoc - 1, true);
    }

    public void testEmptyLiveDocs() throws IOException {
        int maxDoc = TestUtil.nextInt(BaseLiveDocsFormatTestCase.random(), 3, 1000);
        this.testSerialization(maxDoc, 0, false);
        this.testSerialization(maxDoc, 0, true);
    }

    public void testSparseLiveDocs() throws IOException {
        int maxDoc = TestUtil.nextInt(BaseLiveDocsFormatTestCase.random(), 3, 1000);
        this.testSerialization(maxDoc, 1, false);
        this.testSerialization(maxDoc, 1, true);
    }

    @LuceneTestCase.Monster(value="Uses lots of memory")
    public void testOverflow() throws IOException {
        this.testSerialization(0x7FFFFF7F, 0x7FFFFF78, false);
    }

    private void testSerialization(int maxDoc, int numLiveDocs, boolean fixedBitSet) throws IOException {
        Codec codec = Codec.getDefault();
        LiveDocsFormat format = codec.liveDocsFormat();
        final FixedBitSet liveDocs = new FixedBitSet(maxDoc);
        if (numLiveDocs > maxDoc / 2) {
            liveDocs.set(0, maxDoc);
            for (i = 0; i < maxDoc - numLiveDocs; ++i) {
                int clearBit;
                while (!liveDocs.get(clearBit = BaseLiveDocsFormatTestCase.random().nextInt(maxDoc))) {
                }
                liveDocs.clear(clearBit);
            }
        } else {
            for (i = 0; i < numLiveDocs; ++i) {
                int setBit;
                while (liveDocs.get(setBit = BaseLiveDocsFormatTestCase.random().nextInt(maxDoc))) {
                }
                liveDocs.set(setBit);
            }
        }
        Object bits = fixedBitSet ? liveDocs : new Bits(){

            public boolean get(int index) {
                return liveDocs.get(index);
            }

            public int length() {
                return liveDocs.length();
            }
        };
        BaseDirectoryWrapper dir = BaseLiveDocsFormatTestCase.newDirectory();
        SegmentInfo si = new SegmentInfo((Directory)dir, Version.LATEST, Version.LATEST, "foo", maxDoc, BaseLiveDocsFormatTestCase.random().nextBoolean(), false, codec, Collections.emptyMap(), StringHelper.randomId(), Collections.emptyMap(), null);
        SegmentCommitInfo sci = new SegmentCommitInfo(si, 0, 0, 0L, -1L, -1L, StringHelper.randomId());
        format.writeLiveDocs((Bits)bits, (Directory)dir, sci, maxDoc - numLiveDocs, IOContext.DEFAULT);
        sci = new SegmentCommitInfo(si, maxDoc - numLiveDocs, 0, 1L, -1L, -1L, StringHelper.randomId());
        Bits bits2 = format.readLiveDocs((Directory)dir, sci, IOContext.READONCE);
        BaseLiveDocsFormatTestCase.assertEquals((long)maxDoc, (long)bits2.length());
        for (int i = 0; i < maxDoc; ++i) {
            BaseLiveDocsFormatTestCase.assertEquals((Object)bits.get(i), (Object)bits2.get(i));
        }
        dir.close();
    }
}

