/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.security.PrivateKey;
import java.util.Date;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSSEC;
import org.apache.hadoop.shaded.org.xbill.DNS.KEYRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Message;
import org.apache.hadoop.shaded.org.xbill.DNS.Options;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.SIGRecord;

public class SIG0 {
    private static final short VALIDITY = 300;

    private SIG0() {
    }

    public static void signMessage(Message message, KEYRecord key, PrivateKey privkey, SIGRecord previous) throws DNSSEC.DNSSECException {
        int validity = Options.intValue("sig0validity");
        if (validity < 0) {
            validity = 300;
        }
        long now = System.currentTimeMillis();
        Date timeSigned = new Date(now);
        Date timeExpires = new Date(now + (long)(validity * 1000));
        SIGRecord sig = DNSSEC.signMessage(message, previous, key, privkey, timeSigned, timeExpires);
        message.addRecord(sig, 3);
    }

    public static void verifyMessage(Message message, byte[] b, KEYRecord key, SIGRecord previous) throws DNSSEC.DNSSECException {
        SIGRecord sig = null;
        Record[] additional = message.getSectionArray(3);
        for (int i = 0; i < additional.length; ++i) {
            if (additional[i].getType() != 24 || ((SIGRecord)additional[i]).getTypeCovered() != 0) continue;
            sig = (SIGRecord)additional[i];
            break;
        }
        DNSSEC.verifyMessage(message, b, sig, previous, key);
    }
}

