/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class ExecutionTypeRequest
implements Comparable<ExecutionTypeRequest> {
    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static ExecutionTypeRequest newInstance() {
        return ExecutionTypeRequest.newInstance(ExecutionType.GUARANTEED, false);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static ExecutionTypeRequest newInstance(ExecutionType execType) {
        return ExecutionTypeRequest.newInstance(execType, false);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static ExecutionTypeRequest newInstance(ExecutionType execType, boolean ensureExecutionType) {
        ExecutionTypeRequest executionTypeRequest = Records.newRecord(ExecutionTypeRequest.class);
        executionTypeRequest.setExecutionType(execType);
        executionTypeRequest.setEnforceExecutionType(ensureExecutionType);
        return executionTypeRequest;
    }

    @InterfaceAudience.Public
    public abstract void setExecutionType(ExecutionType var1);

    @InterfaceAudience.Public
    public abstract ExecutionType getExecutionType();

    @InterfaceAudience.Public
    public abstract void setEnforceExecutionType(boolean var1);

    @InterfaceAudience.Public
    public abstract boolean getEnforceExecutionType();

    public int hashCode() {
        int prime = 2153;
        int result = 2459;
        ExecutionType executionType = this.getExecutionType();
        boolean ensureExecutionType = this.getEnforceExecutionType();
        result = 2153 * result + (executionType == null ? 0 : executionType.hashCode());
        result = 2153 * result + (ensureExecutionType ? 0 : 1);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutionTypeRequest other = (ExecutionTypeRequest)obj;
        ExecutionType executionType = this.getExecutionType();
        if (executionType == null ? other.getExecutionType() != null : executionType != other.getExecutionType()) {
            return false;
        }
        boolean enforceExecutionType = this.getEnforceExecutionType();
        return enforceExecutionType == other.getEnforceExecutionType();
    }
}

