/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.hs2connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.hive.beeline.hs2connection.HS2ConnectionFileParser;
import org.apache.hive.beeline.hs2connection.KyuubiConfFileParseException;
import org.apache.kyuubi.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KyuubiConfFileParser
implements HS2ConnectionFileParser {
    private static final Logger LOG = LoggerFactory.getLogger(KyuubiConfFileParser.class);
    private static final String TRUSTSTORE_PASS_PROP = "javax.net.ssl.trustStorePassword";
    private static final String TRUSTSTORE_PROP = "javax.net.ssl.trustStore";
    private final boolean loaded;
    private final Properties kyuubiDefaults;

    public KyuubiConfFileParser() {
        this.kyuubiDefaults = new Properties();
        Path filePath = Paths.get(System.getenv("KYUUBI_CONF_DIR"), "kyuubi-defaults.conf");
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            LOG.info("Using {} to construct the connection URL", (Object)filePath.toAbsolutePath());
            try (BufferedReader reader = Files.newBufferedReader(filePath, StandardCharsets.UTF_8);){
                this.kyuubiDefaults.load(reader);
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            this.loaded = true;
        } else {
            LOG.debug("kyuubi-defaults.conf not found for constructing the connection URL");
            this.loaded = false;
        }
    }

    KyuubiConfFileParser(Properties mockedProperties) {
        this.kyuubiDefaults = mockedProperties;
        this.loaded = true;
    }

    @Override
    public Properties getConnectionProperties() throws KyuubiConfFileParseException {
        Properties props = new Properties();
        if (!this.configExists() || this.thriftMode() == THRIFT_MODE.DISABLED) {
            return props;
        }
        props.setProperty("url_prefix", "jdbc:kyuubi://");
        this.addHosts(props);
        this.addSSL(props);
        this.addKerberos(props);
        this.addHttp(props);
        return props;
    }

    private void addSSL(Properties props) {
        String saslQop = this.kyuubiDefaults.getProperty("kyuubi.authentication.sasl.qop", "auth");
        if (!"auth".equalsIgnoreCase(saslQop)) {
            props.setProperty("sasl.qop", saslQop);
        }
    }

    private void addKerberos(Properties props) {
        if (this.kerberosEnabled()) {
            props.setProperty("principal", this.kyuubiDefaults.getProperty("kyuubi.kinit.principal"));
        }
    }

    private void addHttp(Properties props) {
        THRIFT_MODE thriftMode = this.thriftMode();
        assert (thriftMode == THRIFT_MODE.BINARY || thriftMode == THRIFT_MODE.HTTP);
        if (thriftMode == THRIFT_MODE.HTTP) {
            props.setProperty("transportMode", "http");
            String path = this.kyuubiDefaults.getProperty("kyuubi.frontend.thrift.http.path", "cliservice");
            props.setProperty("httpPath", path);
        }
    }

    private void addHosts(Properties props) throws KyuubiConfFileParseException {
        THRIFT_MODE thriftMode = this.thriftMode();
        assert (thriftMode == THRIFT_MODE.BINARY || thriftMode == THRIFT_MODE.HTTP);
        String host = this.kyuubiDefaults.getProperty("kyuubi.frontend.advertised.host");
        if (host == null) {
            host = thriftMode == THRIFT_MODE.BINARY ? this.kyuubiDefaults.getProperty("kyuubi.frontend.thrift.binary.bind.host") : this.kyuubiDefaults.getProperty("kyuubi.frontend.thrift.http.bind.host");
        }
        if (host == null) {
            host = this.kyuubiDefaults.getProperty("kyuubi.frontend.bind.host");
        }
        if (host == null) {
            try {
                String useHostname = this.kyuubiDefaults.getProperty("kyuubi.frontend.connection.url.use.hostname", "true");
                host = Boolean.parseBoolean(useHostname) ? JavaUtils.findLocalInetAddress().getCanonicalHostName() : JavaUtils.findLocalInetAddress().getHostAddress();
            }
            catch (SocketException | UnknownHostException rethrow) {
                throw new KyuubiConfFileParseException(rethrow.getMessage(), rethrow);
            }
        }
        int portNum = this.getPortNum(thriftMode);
        props.setProperty("hosts", host + ":" + portNum);
    }

    private int getPortNum(THRIFT_MODE thriftMode) {
        String port;
        assert (thriftMode == THRIFT_MODE.BINARY || thriftMode == THRIFT_MODE.HTTP);
        if (thriftMode == THRIFT_MODE.BINARY) {
            port = this.kyuubiDefaults.getProperty("kyuubi.frontend.thrift.binary.bind.port");
            if (port == null) {
                port = this.kyuubiDefaults.getProperty("kyuubi.frontend.bind.port", "10009");
            }
        } else {
            port = this.kyuubiDefaults.getProperty("kyuubi.frontend.thrift.http.bind.port", "10010");
        }
        return Integer.parseInt(port);
    }

    @Override
    public boolean configExists() {
        return this.loaded;
    }

    private THRIFT_MODE thriftMode() {
        String[] protocols;
        for (String protocol : protocols = this.kyuubiDefaults.getProperty("kyuubi.frontend.protocols", "THRIFT_BINARY,REST").split(",")) {
            if (protocol.equalsIgnoreCase("THRIFT_BINARY")) {
                return THRIFT_MODE.BINARY;
            }
            if (!protocol.equalsIgnoreCase("THRIFT_HTTP")) continue;
            return THRIFT_MODE.HTTP;
        }
        return THRIFT_MODE.DISABLED;
    }

    private boolean kerberosEnabled() {
        for (String auth : this.kyuubiDefaults.getProperty("kyuubi.authentication", "NONE").split(",")) {
            if (!auth.equalsIgnoreCase("KERBEROS")) continue;
            return true;
        }
        return false;
    }

    private static enum THRIFT_MODE {
        BINARY,
        HTTP,
        DISABLED;

    }
}

