/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.grpc.grpclb;

import javax.annotation.Nullable;
import org.apache.kyuubi.shade.com.google.common.base.MoreObjects;
import org.apache.kyuubi.shade.com.google.common.base.Objects;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.io.grpc.grpclb.GrpclbState;

final class GrpclbConfig {
    private final GrpclbState.Mode mode;
    @Nullable
    private final String serviceName;
    private final long fallbackTimeoutMs;

    private GrpclbConfig(GrpclbState.Mode mode, @Nullable String serviceName, long fallbackTimeoutMs) {
        this.mode = Preconditions.checkNotNull(mode, "mode");
        this.serviceName = serviceName;
        this.fallbackTimeoutMs = fallbackTimeoutMs;
    }

    static GrpclbConfig create(GrpclbState.Mode mode) {
        return GrpclbConfig.create(mode, null, GrpclbState.FALLBACK_TIMEOUT_MS);
    }

    static GrpclbConfig create(GrpclbState.Mode mode, @Nullable String serviceName, long fallbackTimeoutMs) {
        Preconditions.checkArgument(fallbackTimeoutMs > 0L, "Invalid timeout (%s)", fallbackTimeoutMs);
        return new GrpclbConfig(mode, serviceName, fallbackTimeoutMs);
    }

    GrpclbState.Mode getMode() {
        return this.mode;
    }

    long getFallbackTimeoutMs() {
        return this.fallbackTimeoutMs;
    }

    @Nullable
    String getServiceName() {
        return this.serviceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpclbConfig that = (GrpclbConfig)o;
        return this.mode == that.mode && Objects.equal(this.serviceName, that.serviceName) && this.fallbackTimeoutMs == that.fallbackTimeoutMs;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.mode, this.serviceName, this.fallbackTimeoutMs});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("mode", (Object)this.mode).add("serviceName", this.serviceName).add("fallbackTimeoutMs", this.fallbackTimeoutMs).toString();
    }
}

