/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.metadata.jdbc;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.google.common.annotations.VisibleForTesting;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.server.metadata.MetadataStore;
import org.apache.kyuubi.server.metadata.api.KubernetesEngineInfo;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.server.metadata.jdbc.DatabaseType$;
import org.apache.kyuubi.server.metadata.jdbc.GenericDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStore$;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStoreConf$;
import org.apache.kyuubi.server.metadata.jdbc.MySQLDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.PostgreSQLDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.SQLiteDatabaseDialect;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.util.JdbcUtils$;
import org.apache.kyuubi.util.reflect.ReflectUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\r\u0015g\u0001B#G\u0001MC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\u0006W\u0002!\t\u0001\u001c\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u0011\u0019a\b\u0001)A\u0005e\"9Q\u0010\u0001b\u0001\n\u0013q\bbBA\u000f\u0001\u0001\u0006Ia \u0005\u000b\u0003?\u0001\u0001R1A\u0005\n\u0005\u0005\u0002\"CA\u0014\u0001\t\u0007I\u0011BA\u0015\u0011!\tY\u0003\u0001Q\u0001\n\u0005\u001d\u0001\"CA\u0017\u0001\t\u0007I\u0011BA\u0018\u0011!\t9\u0004\u0001Q\u0001\n\u0005E\u0002\"CA\u001d\u0001\t\u0007I\u0011BA\u001e\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005u\u0002\"CA#\u0001\t\u0007I\u0011BA$\u0011!\t)\u0006\u0001Q\u0001\n\u0005%\u0003\"CA,\u0001\t\u0007I\u0011BA-\u0011!\ty\u0007\u0001Q\u0001\n\u0005m\u0003BCA9\u0001\t\u0007I1\u0001'\u0002t!A\u00111\u0010\u0001!\u0002\u0013\t)\bC\u0005\u0002\u0014\u0002\u0011\r\u0011\"\u0003\u0002\u0016\"A\u00111\u0016\u0001!\u0002\u0013\t9\nC\u0004\u0002.\u0002!I!a,\t\u0011\u0005]\u0006\u0001\"\u0001G\u0003sCq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002t\u0002!\t!!>\t\u000f\t5\u0001\u0001\"\u0011\u00020\"9!q\u0002\u0001\u0005B\tE\u0001b\u0002B\u0011\u0001\u0011\u0005#1\u0005\u0005\b\u0005W\u0001A\u0011\tB\u0017\u0011\u001d\u0011Y\u0004\u0001C!\u0005{AqA!\u0011\u0001\t\u0003\u0012\u0019\u0005C\u0005\u0003b\u0001\t\n\u0011\"\u0001\u0003d!I!\u0011\u0010\u0001\u0012\u0002\u0013\u0005!1\u0010\u0005\b\u0005\u007f\u0002A\u0011\tBA\u0011\u001d\u0011)\t\u0001C\u0005\u0005\u000fCqA!*\u0001\t\u0003\u00129\u000bC\u0004\u0003,\u0002!\tE!,\t\u000f\tE\u0006\u0001\"\u0011\u00034\"9!1\u0019\u0001\u0005B\t\u0015\u0007b\u0002Bi\u0001\u0011\u0005#1\u001b\u0005\b\u0005/\u0004A\u0011\tBm\u0011\u001d\u0011i\u000e\u0001C!\u0005?DqA!:\u0001\t\u0013\u00119\u000fC\u0004\u0003z\u0002!IAa?\t\u000f\r\u0005\u0001\u0001\"\u0003\u0004\u0004!91\u0011\u0004\u0001\u0005\n\rm\u0001bBB!\u0001\u0011%11\t\u0005\b\u0007/\u0002A\u0011BB-\u0011\u001d\u00199\u0007\u0001C\u0005\u0007SBqaa\u001c\u0001\t\u0013\u0019\t\bC\u0004\u0004~\u0001!Iaa \b\u000f\r\re\t#\u0001\u0004\u0006\u001a1QI\u0012E\u0001\u0007\u000fCaa[\u001b\u0005\u0002\r=\u0005\"CBIk\t\u0007I\u0011BBJ\u0011!\u0019\u0019+\u000eQ\u0001\n\rU\u0005\"CBSk\t\u0007I\u0011BA\u0011\u0011!\u00199+\u000eQ\u0001\n\u0005\r\u0002\"CBUk\t\u0007I\u0011BA\u0015\u0011!\u0019Y+\u000eQ\u0001\n\u0005\u001d\u0001\"CBWk\t\u0007I\u0011BA\u0011\u0011!\u0019y+\u000eQ\u0001\n\u0005\r\u0002\"CBYk\t\u0007I\u0011BA\u0011\u0011!\u0019\u0019,\u000eQ\u0001\n\u0005\r\u0002\"CB[k\t\u0007I\u0011BB\\\u0011!\u0019y,\u000eQ\u0001\n\re\u0006\"CBak\t\u0007I\u0011BA\u0015\u0011!\u0019\u0019-\u000eQ\u0001\n\u0005\u001d!!\u0005&E\u0005\u000ekU\r^1eCR\f7\u000b^8sK*\u0011q\tS\u0001\u0005U\u0012\u00147M\u0003\u0002J\u0015\u0006AQ.\u001a;bI\u0006$\u0018M\u0003\u0002L\u0019\u000611/\u001a:wKJT!!\u0014(\u0002\r-LX/\u001e2j\u0015\ty\u0005+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0006\u0019qN]4\u0004\u0001M!\u0001\u0001\u0016/a!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0003mC:<'\"A-\u0002\t)\fg/Y\u0005\u00037Z\u0013aa\u00142kK\u000e$\bCA/_\u001b\u0005A\u0015BA0I\u00055iU\r^1eCR\f7\u000b^8sKB\u0011\u0011MY\u0007\u0002\u0019&\u00111\r\u0014\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0011\u0005\u0019LW\"A4\u000b\u0005!d\u0015AB2p]\u001aLw-\u0003\u0002kO\nQ1*_;vE&\u001cuN\u001c4\u0002\rqJg.\u001b;?)\tiw\u000e\u0005\u0002o\u00015\ta\tC\u0003e\u0005\u0001\u0007Q-\u0001\u0004eERK\b/Z\u000b\u0002eB\u00111O\u001e\b\u0003]RL!!\u001e$\u0002\u0019\u0011\u000bG/\u00192bg\u0016$\u0016\u0010]3\n\u0005]D(!\u0002,bYV,\u0017BA={\u0005-)e.^7fe\u0006$\u0018n\u001c8\u000b\u0003m\fQa]2bY\u0006\fq\u0001\u001a2UsB,\u0007%\u0001\bee&4XM]\"mCN\u001cx\n\u001d;\u0016\u0003}\u0004b!!\u0001\u0002\u0004\u0005\u001dQ\"\u0001>\n\u0007\u0005\u0015!P\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0013\t9B\u0004\u0003\u0002\f\u0005M\u0001cAA\u0007u6\u0011\u0011q\u0002\u0006\u0004\u0003#\u0011\u0016A\u0002\u001fs_>$h(C\u0002\u0002\u0016i\fa\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000bu\u0006yAM]5wKJ\u001cE.Y:t\u001fB$\b%\u0001\tnsN\fH\u000e\u0012:jm\u0016\u00148\t\\1tgV\u0011\u00111\u0005\t\u0004+\u0006\u0015\u0012bAA\r-\u0006YAM]5wKJ\u001cE.Y:t+\t\t9!\u0001\u0007ee&4XM]\"mCN\u001c\b%A\u0004eS\u0006dWm\u0019;\u0016\u0005\u0005E\u0002c\u00018\u00024%\u0019\u0011Q\u0007$\u0003-\u001d+g.\u001a:jG\u0012\u000bG/\u00192bg\u0016$\u0015.\u00197fGR\f\u0001\u0002Z5bY\u0016\u001cG\u000fI\u0001\u0010aJLwN]5us\u0016s\u0017M\u00197fIV\u0011\u0011Q\b\t\u0005\u0003\u0003\ty$C\u0002\u0002Bi\u0014qAQ8pY\u0016\fg.\u0001\tqe&|'/\u001b;z\u000b:\f'\r\\3eA\u0005!B-\u0019;bg>,(oY3Qe>\u0004XM\u001d;jKN,\"!!\u0013\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014Y\u0003\u0011)H/\u001b7\n\t\u0005M\u0013Q\n\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u00063bi\u0006\u001cx.\u001e:dKB\u0013x\u000e]3si&,7\u000fI\u0001\rQ&\\\u0017M]5D_:4\u0017nZ\u000b\u0003\u00037\u0002B!!\u0018\u0002l5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'\u0001\u0004iS.\f'/\u001b\u0006\u0005\u0003K\n9'\u0001\u0004{CbDXM\u001d\u0006\u0003\u0003S\n1aY8n\u0013\u0011\ti'a\u0018\u0003\u0019!K7.\u0019:j\u0007>tg-[4\u0002\u001b!L7.\u0019:j\u0007>tg-[4!\u0003AA\u0017n[1sS\u0012\u000bG/Y*pkJ\u001cW-\u0006\u0002\u0002vA!\u0011QLA<\u0013\u0011\tI(a\u0018\u0003!!K7.\u0019:j\t\u0006$\u0018mU8ve\u000e,\u0017!\u00055jW\u0006\u0014\u0018\u000eR1uCN{WO]2fA!\u001a1#a \u0011\t\u0005\u0005\u0015qR\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\tI)a#\u0002\r\r|W.\\8o\u0015\u0011\ti)a\u001a\u0002\r\u001d|wn\u001a7f\u0013\u0011\t\t*a!\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw-\u0001\u0004nCB\u0004XM]\u000b\u0003\u0003/\u0003B!!'\u0002(6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by*\u0001\u0005eCR\f'-\u001b8e\u0015\u0011\t\t+a)\u0002\u000f)\f7m[:p]*!\u0011QUA4\u0003%1\u0017m\u001d;feblG.\u0003\u0003\u0002*\u0006m%\u0001D(cU\u0016\u001cG/T1qa\u0016\u0014\u0018aB7baB,'\u000fI\u0001\u000bS:LGoU2iK6\fGCAAY!\u0011\t\t!a-\n\u0007\u0005U&P\u0001\u0003V]&$\u0018!D4fi&s\u0017\u000e^*dQ\u0016l\u0017\rF\u0002\u0000\u0003wCa\u0001]\fA\u0002\u0005u\u0006\u0003BA`\u00033t1!!1u\u001d\u0011\t\u0019-a6\u000f\t\u0005\u0015\u0017Q\u001b\b\u0005\u0003\u000f\f\u0019N\u0004\u0003\u0002J\u0006Eg\u0002BAf\u0003\u001ftA!!\u0004\u0002N&\t\u0011+\u0003\u0002P!&\u0011QJT\u0005\u0003\u00172K!!\u0013&\n\u0005\u001dC\u0015\u0002BAn\u0003;\u0014A\u0002R1uC\n\f7/\u001a+za\u0016T!!\u001e$\u0002!\u001d,GoU2iK6\fg+\u001a:tS>tG\u0003BAr\u0003_\u0004\"\"!\u0001\u0002f\u0006%\u0018\u0011^Au\u0013\r\t9O\u001f\u0002\u0007)V\u0004H.Z\u001a\u0011\t\u0005\u0005\u00111^\u0005\u0004\u0003[T(aA%oi\"9\u0011\u0011\u001f\rA\u0002\u0005\u001d\u0011!C:dQ\u0016l\u0017-\u0016:m\u0003I9W\r\u001e'bi\u0016\u001cHoU2iK6\fWK\u001d7\u0015\u0007}\f9\u0010C\u0004\u0002zf\u0001\r!a?\u0002\u0015M\u001c\u0007.Z7b+Jd7\u000f\u0005\u0004\u0002~\n\u001d\u0011q\u0001\b\u0005\u0003\u007f\u0014\u0019A\u0004\u0003\u0002\u000e\t\u0005\u0011\"A>\n\u0007\t\u0015!0A\u0004qC\u000e\\\u0017mZ3\n\t\t%!1\u0002\u0002\u0004'\u0016\f(b\u0001B\u0003u\u0006)1\r\\8tK\u0006q\u0011N\\:feRlU\r^1eCR\fG\u0003BAY\u0005'Aa!S\u000eA\u0002\tU\u0001\u0003\u0002B\f\u0005;i!A!\u0007\u000b\u0007\tm\u0001*A\u0002ba&LAAa\b\u0003\u001a\tAQ*\u001a;bI\u0006$\u0018-\u0001\u0007qS\u000e\\W*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0003&\t\u001d\u0002CBA\u0001\u0003\u0007\u0011)\u0002C\u0004\u0003*q\u0001\r!a\u0002\u0002\u001d-LX/\u001e2j\u0013:\u001cH/\u00198dK\u00061BO]1og\u001a|'/\\'fi\u0006$\u0017\r^1Ti\u0006$X\r\u0006\u0005\u0002>\t=\"1\u0007B\u001c\u0011\u001d\u0011\t$\ba\u0001\u0003\u000f\t!\"\u001b3f]RLg-[3s\u0011\u001d\u0011)$\ba\u0001\u0003\u000f\t\u0011B\u001a:p[N#\u0018\r^3\t\u000f\teR\u00041\u0001\u0002\b\u0005YA/\u0019:hKR\u001cF/\u0019;f\u0003-9W\r^'fi\u0006$\u0017\r^1\u0015\t\tU!q\b\u0005\b\u0005cq\u0002\u0019AA\u0004\u0003=9W\r^'fi\u0006$\u0017\r^1MSN$H\u0003\u0004B#\u0005\u000f\u0012\tF!\u0016\u0003Z\tu\u0003CBA\u007f\u0005\u000f\u0011)\u0002C\u0004\u0003J}\u0001\rAa\u0013\u0002\r\u0019LG\u000e^3s!\u0011\u00119B!\u0014\n\t\t=#\u0011\u0004\u0002\u000f\u001b\u0016$\u0018\rZ1uC\u001aKG\u000e^3s\u0011\u001d\u0011\u0019f\ba\u0001\u0003S\fAA\u001a:p[\"9!qK\u0010A\u0002\u0005%\u0018\u0001B:ju\u0016D\u0001Ba\u0017 !\u0003\u0005\ra`\u0001\b_J$WM\u001d\"z\u0011%\u0011yf\bI\u0001\u0002\u0004\t9!A\u0005eSJ,7\r^5p]\u0006Ir-\u001a;NKR\fG-\u0019;b\u0019&\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011)GK\u0002\u0000\u0005OZ#A!\u001b\u0011\t\t-$QO\u0007\u0003\u0005[RAAa\u001c\u0003r\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005gR\u0018AC1o]>$\u0018\r^5p]&!!q\u000fB7\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001aO\u0016$X*\u001a;bI\u0006$\u0018\rT5ti\u0012\"WMZ1vYR$S'\u0006\u0002\u0003~)\"\u0011q\u0001B4\u00035\u0019w.\u001e8u\u001b\u0016$\u0018\rZ1uCR!\u0011\u0011\u001eBB\u0011\u001d\u0011IE\ta\u0001\u0005\u0017\n1#Y:tK6\u0014G.Z,iKJ,7\t\\1vg\u0016$b!a\u0002\u0003\n\n-\u0005b\u0002B%G\u0001\u0007!1\n\u0005\b\u0005\u001b\u001b\u0003\u0019\u0001BH\u0003\u0019\u0001\u0018M]1ngB1!\u0011\u0013BN\u0005?k!Aa%\u000b\t\tU%qS\u0001\b[V$\u0018M\u00197f\u0015\r\u0011IJ_\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BO\u0005'\u0013!\u0002T5ti\n+hMZ3s!\u0011\t\tA!)\n\u0007\t\r&PA\u0002B]f\fa\"\u001e9eCR,W*\u001a;bI\u0006$\u0018\r\u0006\u0003\u00022\n%\u0006BB%%\u0001\u0004\u0011)\"A\u000edY\u0016\fg.\u001e9NKR\fG-\u0019;b\u0005fLE-\u001a8uS\u001aLWM\u001d\u000b\u0005\u0003c\u0013y\u000bC\u0004\u00032\u0015\u0002\r!a\u0002\u0002)\rdW-\u00198va6+G/\u00193bi\u0006\u0014\u00150Q4f)\u0019\tIO!.\u0003@\"9!q\u0017\u0014A\u0002\te\u0016AB7bq\u0006;W\r\u0005\u0003\u0002\u0002\tm\u0016b\u0001B_u\n!Aj\u001c8h\u0011\u001d\u0011\tM\na\u0001\u0003S\fQ\u0001\\5nSR\f!$\u001e9tKJ$8*\u001e2fe:,G/Z:F]\u001eLg.Z%oM>$B!!-\u0003H\"9!\u0011Z\u0014A\u0002\t-\u0017AC3oO&tW-\u00138g_B!!q\u0003Bg\u0013\u0011\u0011yM!\u0007\u0003)-+(-\u001a:oKR,7/\u00128hS:,\u0017J\u001c4p\u0003m9W\r^&vE\u0016\u0014h.\u001a;fg6+G/Y#oO&tW-\u00138g_R!!1\u001aBk\u0011\u001d\u0011\t\u0004\u000ba\u0001\u0003\u000f\tqe\u00197fC:,\boS;cKJtW\r^3t\u000b:<\u0017N\\3J]\u001a|')_%eK:$\u0018NZ5feR!\u0011\u0011\u0017Bn\u0011\u001d\u0011\t$\u000ba\u0001\u0003\u000f\t\u0001e\u00197fC:,\boS;cKJtW\r^3t\u000b:<\u0017N\\3J]\u001a|')_!hKR1\u0011\u0011\u001eBq\u0005GDqAa.+\u0001\u0004\u0011I\fC\u0004\u0003B*\u0002\r!!;\u0002\u001b\t,\u0018\u000e\u001c3NKR\fG-\u0019;b)\u0011\u0011)E!;\t\u000f\t-8\u00061\u0001\u0003n\u0006I!/Z:vYR\u001cV\r\u001e\t\u0005\u0005_\u0014)0\u0004\u0002\u0003r*\u0019!1\u001f-\u0002\u0007M\fH.\u0003\u0003\u0003x\nE(!\u0003*fgVdGoU3u\u0003]\u0011W/\u001b7e\u0017V\u0014WM\u001d8fi\u0016\u001cX*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0003~\n}\bCBA\u007f\u0005\u000f\u0011Y\rC\u0004\u0003l2\u0002\rA!<\u0002\u000f\u0015DXmY;uKRA\u0011\u0011WB\u0003\u0007\u001f\u0019\t\u0002C\u0004\u0004\b5\u0002\ra!\u0003\u0002\t\r|gN\u001c\t\u0005\u0005_\u001cY!\u0003\u0003\u0004\u000e\tE(AC\"p]:,7\r^5p]\"9!1_\u0017A\u0002\u0005\u001d\u0001b\u0002BG[\u0001\u000711\u0003\t\u0007\u0003\u0003\u0019)Ba(\n\u0007\r]!P\u0001\u0006=e\u0016\u0004X-\u0019;fIz\nQb^5uQJ+7/\u001e7u'\u0016$X\u0003BB\u000f\u0007K!\u0002ba\b\u0004<\ru2q\b\u000b\u0005\u0007C\u0019\t\u0004\u0005\u0003\u0004$\r\u0015B\u0002\u0001\u0003\b\u0007Oq#\u0019AB\u0015\u0005\u0005!\u0016\u0003BB\u0016\u0005?\u0003B!!\u0001\u0004.%\u00191q\u0006>\u0003\u000f9{G\u000f[5oO\"911\u0007\u0018A\u0002\rU\u0012!\u00014\u0011\u0011\u0005\u00051q\u0007Bw\u0007CI1a!\u000f{\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0004\b9\u0002\ra!\u0003\t\u000f\tMh\u00061\u0001\u0002\b!9!Q\u0012\u0018A\u0002\rM\u0011aD<ji\",\u0006\u000fZ1uK\u000e{WO\u001c;\u0016\t\r\u001531\n\u000b\t\u0007\u000f\u001a\tfa\u0015\u0004VQ!1\u0011JB'!\u0011\u0019\u0019ca\u0013\u0005\u000f\r\u001drF1\u0001\u0004*!911G\u0018A\u0002\r=\u0003\u0003CA\u0001\u0007o\tIo!\u0013\t\u000f\r\u001dq\u00061\u0001\u0004\n!9!1_\u0018A\u0002\u0005\u001d\u0001b\u0002BG_\u0001\u000711C\u0001\u0013g\u0016$8\u000b^1uK6,g\u000e\u001e)be\u0006l7\u000f\u0006\u0004\u00022\u000em3Q\r\u0005\b\u0007;\u0002\u0004\u0019AB0\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0005\u0003\u0003p\u000e\u0005\u0014\u0002BB2\u0005c\u0014\u0011\u0003\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u\u0011\u001d\u0011i\t\ra\u0001\u0007'\tQB^1mk\u0016\f5o\u0015;sS:<G\u0003BA\u0004\u0007WBqa!\u001c2\u0001\u0004\u0011y*A\u0002pE*\f!b\u001d;sS:<''T1q)\u0011\u0019\u0019h!\u001f\u0011\u0011\u0005%1QOA\u0004\u0003\u000fIAaa\u001e\u0002\u001c\t\u0019Q*\u00199\t\u000f\rm$\u00071\u0001\u0002\b\u0005\u00191\u000f\u001e:\u0002\u0015M$(/\u001b8heM+\u0017\u000f\u0006\u0003\u0002|\u000e\u0005\u0005bBB>g\u0001\u0007\u0011qA\u0001\u0012\u0015\u0012\u00135)T3uC\u0012\fG/Y*u_J,\u0007C\u000186'\r)4\u0011\u0012\t\u0005\u0003\u0003\u0019Y)C\u0002\u0004\u000ej\u0014a!\u00118z%\u00164GCABC\u0003I\u00196\tS#N\u0003~+&\u000bT0Q\u0003R#VI\u0015(\u0016\u0005\rU\u0005\u0003BBL\u0007?k!a!'\u000b\t\rm5QT\u0001\t[\u0006$8\r[5oO*\u0019\u0011q\n>\n\t\r\u00056\u0011\u0014\u0002\u0006%\u0016<W\r_\u0001\u0014'\u000eCU)T!`+Jcu\fU!U)\u0016\u0013f\nI\u0001\u000f\u001b\u0016#\u0016\tR!U\u0003~#\u0016I\u0011'F\u0003=iU\tV!E\u0003R\u000bu\fV!C\u0019\u0016\u0003\u0013\u0001E'F)\u0006#\u0015\tV!`\u0007>cU+\u0014(T\u0003EiU\tV!E\u0003R\u000bulQ(M+6s5\u000bI\u0001\u001d\u0017V\u0013UI\u0015(F)\u0016\u001bv,\u0012(H\u0013:+u,\u0013(G\u001f~#\u0016I\u0011'F\u0003uYUKQ#S\u001d\u0016#ViU0F\u001d\u001eKe*R0J\u001d\u001a{u\fV!C\u0019\u0016\u0003\u0013!I&V\u0005\u0016\u0013f*\u0012+F'~+ejR%O\u000b~KeJR(`\u0017\u0016KvlQ(M+6s\u0015AI&V\u0005\u0016\u0013f*\u0012+F'~+ejR%O\u000b~KeJR(`\u0017\u0016KvlQ(M+6s\u0005%\u0001\u0010L+\n+%KT#U\u000bN{VIT$J\u001d\u0016{\u0016J\u0014$P?\u000e{E*V'O'V\u00111\u0011\u0018\t\u0007\u0007w\u001bi,a\t\u000e\u0005\t]\u0015\u0002\u0002B\u0005\u0005/\u000bqdS+C\u000bJsU\tV#T?\u0016su)\u0013(F?&seiT0D\u001f2+VJT*!\u0003\tZUKQ#S\u001d\u0016#ViU0F\u001d\u001eKe*R0J\u001d\u001a{ulQ(M+6s5kX*U%\u0006\u00193*\u0016\"F%:+E+R*`\u000b:;\u0015JT#`\u0013:3ujX\"P\u0019VkejU0T)J\u0003\u0003")
public class JDBCMetadataStore
implements MetadataStore,
Logging {
    private String mysqlDriverClass;
    private final Enumeration.Value dbType;
    private final Option<String> driverClassOpt;
    private final String driverClass;
    private final GenericDatabaseDialect dialect;
    private final boolean priorityEnabled;
    private final Properties datasourceProperties;
    private final HikariConfig hikariConfig;
    @VisibleForTesting
    private final HikariDataSource hikariDataSource;
    private final ObjectMapper mapper;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private Enumeration.Value dbType() {
        return this.dbType;
    }

    private Option<String> driverClassOpt() {
        return this.driverClassOpt;
    }

    private String mysqlDriverClass$lzycompute() {
        JDBCMetadataStore jDBCMetadataStore = this;
        synchronized (jDBCMetadataStore) {
            if (!this.bitmap$0) {
                this.mysqlDriverClass = ReflectUtils$.MODULE$.isClassLoadable("com.mysql.cj.jdbc.Driver", ReflectUtils$.MODULE$.isClassLoadable$default$2()) ? "com.mysql.cj.jdbc.Driver" : "com.mysql.jdbc.Driver";
                this.bitmap$0 = true;
            }
        }
        return this.mysqlDriverClass;
    }

    private String mysqlDriverClass() {
        if (!this.bitmap$0) {
            return this.mysqlDriverClass$lzycompute();
        }
        return this.mysqlDriverClass;
    }

    private String driverClass() {
        return this.driverClass;
    }

    private GenericDatabaseDialect dialect() {
        return this.dialect;
    }

    private boolean priorityEnabled() {
        return this.priorityEnabled;
    }

    private Properties datasourceProperties() {
        return this.datasourceProperties;
    }

    private HikariConfig hikariConfig() {
        return this.hikariConfig;
    }

    public HikariDataSource hikariDataSource() {
        return this.hikariDataSource;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private void initSchema() {
        this.getInitSchema(this.dbType()).foreach((Function1 & Serializable & scala.Serializable)schema -> {
            JDBCMetadataStore.$anonfun$initSchema$1(this, schema);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> getInitSchema(Enumeration.Value dbType) {
        ClassLoader classLoader = Utils$.MODULE$.getContextOrKyuubiClassLoader();
        String schemaPackage = new java.lang.StringBuilder(4).append("sql/").append(dbType.toString().toLowerCase()).toString();
        return Option$.MODULE$.apply((Object)classLoader.getResource(schemaPackage)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toURI()).flatMap((Function1 & Serializable & scala.Serializable)uri -> {
            String[] stringArray;
            String string = uri.getScheme();
            String string2 = "jar";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                try (FileSystem fs = FileSystems.newFileSystem(uri, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());){
                    stringArray = (String[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fs.getPath(schemaPackage, new String[0]), 1, new FileVisitOption[0]).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> ((Object)x$3.getFileName()).toString()).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getInitSchema$4(name))).toArray(ClassTag$.MODULE$.apply(String.class));
                }
            } else {
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Paths.get(uri).toFile().listFiles((x$4, name) -> JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)name).isDefined()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
            String[] pathNames = stringArray;
            return this.getLatestSchemaUrl((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])pathNames)).map((Function1 & Serializable & scala.Serializable)name -> new java.lang.StringBuilder(1).append(schemaPackage).append("/").append((String)name).toString()).map((Function1 & Serializable & scala.Serializable)schemaUrl -> {
                String string;
                try (InputStream inputStream = classLoader.getResourceAsStream((String)schemaUrl);){
                    string = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
                }
                return string;
            });
        });
    }

    public Tuple3<Object, Object, Object> getSchemaVersion(String schemaUrl) {
        Option option = JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)schemaUrl);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(2))).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(3))).toInt()));
        }
        throw new KyuubiException(new java.lang.StringBuilder(20).append("Invalid schema url: ").append(schemaUrl).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
    }

    public Option<String> getLatestSchemaUrl(Seq<String> schemaUrls) {
        return ((TraversableLike)schemaUrls.sortWith((Function2 & Serializable & scala.Serializable)(u1, u2) -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getLatestSchemaUrl$1(this, u1, u2)))).headOption();
    }

    @Override
    public void close() {
        this.hikariDataSource().close();
    }

    @Override
    public void insertMetadata(Metadata metadata) {
        String query = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(472).append("\n         |INSERT INTO ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("(\n         |identifier,\n         |session_type,\n         |real_user,\n         |user_name,\n         |ip_address,\n         |kyuubi_instance,\n         |state,\n         |resource,\n         |class_name,\n         |request_name,\n         |request_conf,\n         |request_args,\n         |create_time,\n         |engine_type,\n         |cluster_manager,\n         |priority\n         |)\n         |VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n         |").toString())).stripMargin();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata.identifier(), metadata.sessionType().toString(), metadata.realUser(), metadata.username(), metadata.ipAddress(), metadata.kyuubiInstance(), metadata.state(), metadata.resource(), metadata.className(), metadata.requestName(), this.valueAsString(metadata.requestConf()), this.valueAsString(metadata.requestArgs()), BoxesRunTime.boxToLong((long)metadata.createTime()), Option$.MODULE$.apply((Object)metadata.engineType()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toUpperCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms()), metadata.clusterManager().orNull(Predef$.MODULE$.$conforms()), BoxesRunTime.boxToInteger((int)metadata.priority())}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public synchronized Option<Metadata> pickMetadata(String kyuubiInstance) {
        return JdbcUtils$.MODULE$.executeQueryWithRowMapper(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(101).append("SELECT identifier FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("\n         |WHERE state=?\n         |ORDER BY ").append((Object)(this.priorityEnabled() ? "priority DESC, " : "")).append("create_time ASC LIMIT 1\n         |").toString())).stripMargin(), (Function1 & Serializable & scala.Serializable)stmt -> {
            stmt.setString(1, OperationState$.MODULE$.INITIALIZED().toString());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)resultSet -> resultSet.getString(1), (DataSource)this.hikariDataSource()).headOption().filter((Function1 & Serializable & scala.Serializable)preSelectedBatchId -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$pickMetadata$3(this, kyuubiInstance, preSelectedBatchId))).map((Function1 & Serializable & scala.Serializable)pickedBatchId -> this.getMetadata((String)pickedBatchId));
    }

    @Override
    public boolean transformMetadataState(String identifier, String fromState, String targetState) {
        String query = new java.lang.StringBuilder(56).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" SET state = ? WHERE identifier = ? AND state = ?").toString();
        return BoxesRunTime.unboxToBoolean((Object)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$transformMetadataState$1(this, query, fromState, identifier, targetState, connection)), (DataSource)this.hikariDataSource()));
    }

    @Override
    public Metadata getMetadata(String identifier) {
        String query = new java.lang.StringBuilder(34).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        return (Metadata)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> (Metadata)this.withResultSet((Connection)connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}), (Function1 & Serializable & scala.Serializable)rs -> (Metadata)this.buildMetadata((ResultSet)rs).headOption().orNull(Predef$.MODULE$.$conforms())), (DataSource)this.hikariDataSource());
    }

    @Override
    public Seq<Metadata> getMetadataList(MetadataFilter filter, int from, int size, Option<String> orderBy, String direction) {
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append("SELECT ");
        queryBuilder.append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_COLUMNS());
        queryBuilder.append(new java.lang.StringBuilder(6).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        queryBuilder.append(new java.lang.StringBuilder(1).append(" ").append(this.assembleWhereClause(filter, (ListBuffer<Object>)params)).toString());
        orderBy.foreach((Function1 & Serializable & scala.Serializable)o -> queryBuilder.append(new java.lang.StringBuilder(12).append(" ORDER BY ").append((String)o).append(" ").append(direction).append(" ").toString()));
        queryBuilder.append(this.dialect().limitClause(size, from));
        String query = queryBuilder.toString();
        return (Seq)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> (Seq)this.withResultSet((Connection)connection, query, (Seq<Object>)params.toSeq(), (Function1 & Serializable & scala.Serializable)rs -> this.buildMetadata((ResultSet)rs)), (DataSource)this.hikariDataSource());
    }

    @Override
    public Option<String> getMetadataList$default$4() {
        return new Some((Object)"key_id");
    }

    @Override
    public String getMetadataList$default$5() {
        return "ASC";
    }

    @Override
    public int countMetadata(MetadataFilter filter) {
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append(new java.lang.StringBuilder(21).append("SELECT COUNT(1) FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        queryBuilder.append(new java.lang.StringBuilder(1).append(" ").append(this.assembleWhereClause(filter, (ListBuffer<Object>)params)).toString());
        String query = queryBuilder.toString();
        return BoxesRunTime.unboxToInt((Object)JdbcUtils$.MODULE$.executeQueryWithRowMapper(query, (Function1 & Serializable & scala.Serializable)stmt -> {
            this.setStatementParams(stmt, (Seq<Object>)params.toSeq());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)resultSet -> BoxesRunTime.boxToInteger((int)resultSet.getInt(1)), (DataSource)this.hikariDataSource()).head());
    }

    private String assembleWhereClause(MetadataFilter filter, ListBuffer<Object> params) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        ListBuffer whereConditions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1 = 1"}));
        Option$.MODULE$.apply((Object)filter.sessionType()).foreach((Function1 & Serializable & scala.Serializable)sessionType -> {
            whereConditions.$plus$eq((Object)"session_type = ?");
            return params.$plus$eq((Object)sessionType.toString());
        });
        Option$.MODULE$.apply((Object)filter.engineType()).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$2(x$7))).foreach((Function1 & Serializable & scala.Serializable)engineType -> {
            whereConditions.$plus$eq((Object)"UPPER(engine_type) = ?");
            return params.$plus$eq((Object)engineType.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.username()).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$4(x$8))).foreach((Function1 & Serializable & scala.Serializable)username -> {
            whereConditions.$plus$eq((Object)"user_name = ?");
            return params.$plus$eq(username);
        });
        Option$.MODULE$.apply((Object)filter.state()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$6(x$9))).foreach((Function1 & Serializable & scala.Serializable)state -> {
            whereConditions.$plus$eq((Object)"state = ?");
            return params.$plus$eq((Object)state.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.requestName()).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$8(x$10))).foreach((Function1 & Serializable & scala.Serializable)requestName -> {
            whereConditions.$plus$eq((Object)"request_name = ?");
            return params.$plus$eq(requestName);
        });
        Option$.MODULE$.apply((Object)filter.kyuubiInstance()).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$10(x$11))).foreach((Function1 & Serializable & scala.Serializable)kyuubiInstance -> {
            whereConditions.$plus$eq((Object)"kyuubi_instance = ?");
            return params.$plus$eq(kyuubiInstance);
        });
        if (filter.createTime() > 0L) {
            whereConditions.$plus$eq((Object)"create_time >= ?");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.createTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (filter.endTime() > 0L) {
            whereConditions.$plus$eq((Object)"end_time > 0");
            whereConditions.$plus$eq((Object)"end_time <= ?");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.endTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (filter.peerInstanceClosed()) {
            whereConditions.$plus$eq((Object)"peer_instance_closed = ?");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)filter.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return whereConditions.mkString("WHERE ", " AND ", "");
    }

    @Override
    public void updateMetadata(Metadata metadata) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append(new java.lang.StringBuilder(7).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        ListBuffer setClauses = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option$.MODULE$.apply((Object)metadata.kyuubiInstance()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            setClauses.$plus$eq((Object)"kyuubi_instance = ?");
            return params.$plus$eq((Object)metadata.kyuubiInstance());
        });
        Option$.MODULE$.apply((Object)metadata.state()).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            setClauses.$plus$eq((Object)"state = ?");
            return params.$plus$eq((Object)metadata.state());
        });
        Option$.MODULE$.apply(metadata.requestConf()).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.nonEmpty())).foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            setClauses.$plus$eq((Object)"request_conf =?");
            return params.$plus$eq((Object)this.valueAsString(metadata.requestConf()));
        });
        metadata.clusterManager().foreach((Function1 & Serializable & scala.Serializable)cm -> {
            setClauses.$plus$eq((Object)"cluster_manager = ?");
            return params.$plus$eq(cm);
        });
        if (metadata.endTime() > 0L) {
            setClauses.$plus$eq((Object)"end_time = ?");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.endTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (metadata.engineOpenTime() > 0L) {
            setClauses.$plus$eq((Object)"engine_open_time = ?");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.engineOpenTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Option$.MODULE$.apply((Object)metadata.engineId()).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            setClauses.$plus$eq((Object)"engine_id = ?");
            return params.$plus$eq((Object)metadata.engineId());
        });
        Option$.MODULE$.apply((Object)metadata.engineName()).foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            setClauses.$plus$eq((Object)"engine_name = ?");
            return params.$plus$eq((Object)metadata.engineName());
        });
        Option$.MODULE$.apply((Object)metadata.engineUrl()).foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            setClauses.$plus$eq((Object)"engine_url = ?");
            return params.$plus$eq((Object)metadata.engineUrl());
        });
        Option$.MODULE$.apply((Object)metadata.engineState()).foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            setClauses.$plus$eq((Object)"engine_state = ?");
            return params.$plus$eq((Object)metadata.engineState());
        });
        metadata.engineError().foreach((Function1 & Serializable & scala.Serializable)error -> {
            setClauses.$plus$eq((Object)"engine_error = ?");
            return params.$plus$eq(error);
        });
        if (metadata.peerInstanceClosed()) {
            setClauses.$plus$eq((Object)"peer_instance_closed = ?");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)metadata.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = setClauses.nonEmpty() ? queryBuilder.append(setClauses.mkString(" SET ", ", ", "")) : BoxedUnit.UNIT;
        queryBuilder.append(" WHERE identifier = ?");
        params.$plus$eq((Object)metadata.identifier());
        String query = queryBuilder.toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.withUpdateCount(connection, query, (Seq<Object>)params.toSeq(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)updateCount -> {
                if (updateCount == 0) {
                    throw new KyuubiException(new java.lang.StringBuilder(52).append("Error updating metadata for ").append(metadata$2.identifier()).append(" by SQL: ").append(query$5).append(", ").append("with params: ").append(params$4.mkString(", ")).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                }
            });
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public void cleanupMetadataByIdentifier(String identifier) {
        String query = new java.lang.StringBuilder(33).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public int cleanupMetadataByAge(long maxAge, int limit) {
        long minEndTime = System.currentTimeMillis() - maxAge;
        String query = new java.lang.StringBuilder(69).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE end_time > 0 AND end_time < ? AND create_time < ?").append(" ").append(this.dialect().deleteFromLimitClause(limit)).toString();
        return BoxesRunTime.unboxToInt((Object)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)JDBCMetadataStore.$anonfun$cleanupMetadataByAge$1(this, query, minEndTime, maxAge, limit, connection)), (DataSource)this.hikariDataSource()));
    }

    @Override
    public void upsertKubernetesEngineInfo(KubernetesEngineInfo engineInfo) {
        String query = this.dialect().insertOrReplace(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$KUBERNETES_ENGINE_INFO_TABLE(), JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$KUBERNETES_ENGINE_INFO_COLUMNS(), JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$KUBERNETES_ENGINE_INFO_KEY_COLUMN(), engineInfo.identifier());
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{engineInfo.identifier(), engineInfo.context().orNull(Predef$.MODULE$.$conforms()), engineInfo.namespace().orNull(Predef$.MODULE$.$conforms()), engineInfo.podName(), engineInfo.podState(), engineInfo.containerState(), engineInfo.engineId(), engineInfo.engineName(), engineInfo.engineState(), engineInfo.engineError().orNull(Predef$.MODULE$.$conforms()), BoxesRunTime.boxToLong((long)System.currentTimeMillis())}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public KubernetesEngineInfo getKubernetesMetaEngineInfo(String identifier) {
        String query = new java.lang.StringBuilder(34).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$KUBERNETES_ENGINE_INFO_COLUMNS_STR()).append(" FROM").append(" ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$KUBERNETES_ENGINE_INFO_TABLE()).append(" WHERE identifier = ?").toString();
        return (KubernetesEngineInfo)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> (KubernetesEngineInfo)this.withResultSet((Connection)connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}), (Function1 & Serializable & scala.Serializable)rs -> (KubernetesEngineInfo)this.buildKubernetesMetadata((ResultSet)rs).headOption().orNull(Predef$.MODULE$.$conforms())), (DataSource)this.hikariDataSource());
    }

    @Override
    public void cleanupKubernetesEngineInfoByIdentifier(String identifier) {
        String query = new java.lang.StringBuilder(33).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$KUBERNETES_ENGINE_INFO_TABLE()).append(" WHERE identifier = ?").toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public int cleanupKubernetesEngineInfoByAge(long maxAge, int limit) {
        long minUpdateTime = System.currentTimeMillis() - maxAge;
        String query = new java.lang.StringBuilder(35).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$KUBERNETES_ENGINE_INFO_TABLE()).append(" WHERE update_time < ?").append(" ").append(this.dialect().deleteFromLimitClause(limit)).toString();
        return BoxesRunTime.unboxToInt((Object)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)JDBCMetadataStore.$anonfun$cleanupKubernetesEngineInfoByAge$1(this, query, minUpdateTime, maxAge, limit, connection)), (DataSource)this.hikariDataSource()));
    }

    private Seq<Metadata> buildMetadata(ResultSet resultSet) {
        Seq seq;
        try {
            ListBuffer metadataList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (resultSet.next()) {
                String identifier = resultSet.getString("identifier");
                Enumeration.Value sessionType = SessionType$.MODULE$.withName(resultSet.getString("session_type"));
                String realUser = resultSet.getString("real_user");
                String userName = resultSet.getString("user_name");
                String ipAddress = resultSet.getString("ip_address");
                String kyuubiInstance = resultSet.getString("kyuubi_instance");
                String state = resultSet.getString("state");
                String resource = resultSet.getString("resource");
                String className = resultSet.getString("class_name");
                String requestName = resultSet.getString("request_name");
                scala.collection.immutable.Map<String, String> requestConf = this.string2Map(resultSet.getString("request_conf"));
                Seq<String> requestArgs = this.string2Seq(resultSet.getString("request_args"));
                long createTime = resultSet.getLong("create_time");
                String engineType = resultSet.getString("engine_type");
                Option clusterManager = Option$.MODULE$.apply((Object)resultSet.getString("cluster_manager"));
                long engineOpenTime = resultSet.getLong("engine_open_time");
                String engineId = resultSet.getString("engine_id");
                String engineName = resultSet.getString("engine_name");
                String engineUrl = resultSet.getString("engine_url");
                String engineState = resultSet.getString("engine_state");
                Option engineError = Option$.MODULE$.apply((Object)resultSet.getString("engine_error"));
                long endTime = resultSet.getLong("end_time");
                boolean peerInstanceClosed = resultSet.getBoolean("peer_instance_closed");
                String x$1 = identifier;
                Enumeration.Value x$2 = sessionType;
                String x$3 = realUser;
                String x$4 = userName;
                String x$5 = ipAddress;
                String x$6 = kyuubiInstance;
                String x$7 = state;
                String x$8 = resource;
                String x$9 = className;
                String x$10 = requestName;
                scala.collection.immutable.Map<String, String> x$11 = requestConf;
                Seq<String> x$12 = requestArgs;
                long x$13 = createTime;
                String x$14 = engineType;
                Option x$15 = clusterManager;
                long x$16 = engineOpenTime;
                String x$17 = engineId;
                String x$18 = engineName;
                String x$19 = engineUrl;
                String x$20 = engineState;
                Option x$21 = engineError;
                long x$22 = endTime;
                boolean x$23 = peerInstanceClosed;
                int x$24 = Metadata$.MODULE$.apply$default$23();
                Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20, (Option<String>)x$21, x$22, x$24, x$23);
                metadataList.$plus$eq((Object)metadata);
            }
            seq = metadataList.toSeq();
        }
        finally {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> resultSet.close());
        }
        return seq;
    }

    private Seq<KubernetesEngineInfo> buildKubernetesMetadata(ResultSet resultSet) {
        Seq seq;
        try {
            ListBuffer metadataList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (resultSet.next()) {
                String identifier = resultSet.getString("identifier");
                Option context = Option$.MODULE$.apply((Object)resultSet.getString("context"));
                Option namespace = Option$.MODULE$.apply((Object)resultSet.getString("namespace"));
                String pod = resultSet.getString("pod_name");
                String podState = resultSet.getString("pod_state");
                String containerState = resultSet.getString("container_state");
                String appId = resultSet.getString("engine_id");
                String appName = resultSet.getString("engine_name");
                String appState = resultSet.getString("engine_state");
                Option appError = Option$.MODULE$.apply((Object)resultSet.getString("engine_error"));
                long updateTime = resultSet.getLong("update_time");
                KubernetesEngineInfo metadata = new KubernetesEngineInfo(identifier, (Option<String>)context, (Option<String>)namespace, pod, podState, containerState, appId, appName, appState, (Option<String>)appError, updateTime);
                metadataList.$plus$eq((Object)metadata);
            }
            seq = metadataList.toSeq();
        }
        finally {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> resultSet.close());
        }
        return seq;
    }

    private void execute(Connection conn, String sql, Seq<Object> params) {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(28).append("execute sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                ((PreparedStatement)statement.elem).execute();
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$1.elem).close());
            }
        }
    }

    private <T> T withResultSet(Connection conn, String sql, Seq<Object> params, Function1<ResultSet, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("executeQuery sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        ObjectRef resultSet = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                resultSet.elem = ((PreparedStatement)statement.elem).executeQuery();
                object = f.apply((Object)((ResultSet)resultSet.elem));
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((ResultSet)resultSet.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ResultSet)resultSet$3.elem).close());
            }
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$2.elem).close());
            }
        }
        return (T)object;
    }

    private <T> T withUpdateCount(Connection conn, String sql, Seq<Object> params, Function1<Object, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("executeUpdate sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                object = f.apply((Object)BoxesRunTime.boxToInteger((int)((PreparedStatement)statement.elem).executeUpdate()));
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$3.elem).close());
            }
        }
        return (T)object;
    }

    private void setStatementParams(PreparedStatement statement, Seq<Object> params) {
        ((IterableLike)params.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JDBCMetadataStore.$anonfun$setStatementParams$1(statement, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private String valueAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    private scala.collection.immutable.Map<String, String> string2Map(String str) {
        if (str == null || str.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        return (scala.collection.immutable.Map)this.mapper().readValue(str, scala.collection.immutable.Map.class);
    }

    private Seq<String> string2Seq(String str) {
        if (str == null || str.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)this.mapper().readValue(str, Seq.class);
    }

    public static final /* synthetic */ void $anonfun$initSchema$5(JDBCMetadataStore $this, Connection connection$1, String ddlStatement) {
        $this.execute(connection$1, ddlStatement, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(81).append("Execute init schema ddl successfully.\n                    |").append(ddlStatement).append("\n                    |").toString())).stripMargin());
    }

    public static final /* synthetic */ void $anonfun$initSchema$1(JDBCMetadataStore $this, String schema) {
        String[] ddlStatements = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.trim().split(";"))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ddlStatements)).foreach((Function1 & Serializable & scala.Serializable)ddlStatement -> {
                JDBCMetadataStore.$anonfun$initSchema$5($this, connection, ddlStatement);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }, (DataSource)$this.hikariDataSource());
    }

    public static final /* synthetic */ boolean $anonfun$getInitSchema$4(String name) {
        return JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)name).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$getLatestSchemaUrl$1(JDBCMetadataStore $this, String u1, String u2) {
        Tuple3<Object, Object, Object> v1 = $this.getSchemaVersion(u1);
        Tuple3<Object, Object, Object> v2 = $this.getSchemaVersion(u2);
        return BoxesRunTime.unboxToInt((Object)v1._1()) > BoxesRunTime.unboxToInt((Object)v2._1()) || BoxesRunTime.unboxToInt((Object)v1._1()) == BoxesRunTime.unboxToInt((Object)v2._1()) && BoxesRunTime.unboxToInt((Object)v1._2()) > BoxesRunTime.unboxToInt((Object)v2._2()) || BoxesRunTime.unboxToInt((Object)v1._1()) == BoxesRunTime.unboxToInt((Object)v2._1()) && BoxesRunTime.unboxToInt((Object)v1._2()) == BoxesRunTime.unboxToInt((Object)v2._2()) && BoxesRunTime.unboxToInt((Object)v1._3()) > BoxesRunTime.unboxToInt((Object)v2._3());
    }

    public static final /* synthetic */ void $anonfun$pickMetadata$4(String kyuubiInstance$1, String preSelectedBatchId$1, PreparedStatement stmt) {
        stmt.setString(1, kyuubiInstance$1);
        stmt.setString(2, OperationState$.MODULE$.PENDING().toString());
        stmt.setString(3, preSelectedBatchId$1);
        stmt.setString(4, OperationState$.MODULE$.INITIALIZED().toString());
    }

    public static final /* synthetic */ boolean $anonfun$pickMetadata$3(JDBCMetadataStore $this, String kyuubiInstance$1, String preSelectedBatchId) {
        return JdbcUtils$.MODULE$.executeUpdate(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(106).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("\n           |SET kyuubi_instance=?, state=?\n           |WHERE identifier=? AND state=?\n           |").toString())).stripMargin(), (Function1 & Serializable & scala.Serializable)stmt -> {
            JDBCMetadataStore.$anonfun$pickMetadata$4(kyuubiInstance$1, preSelectedBatchId, stmt);
            return BoxedUnit.UNIT;
        }, (DataSource)$this.hikariDataSource()) == 1;
    }

    public static final /* synthetic */ boolean $anonfun$transformMetadataState$1(JDBCMetadataStore $this, String query$2, String fromState$1, String identifier$1, String targetState$1, Connection connection) {
        return BoxesRunTime.unboxToBoolean($this.withUpdateCount(connection, query$2, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fromState$1, identifier$1, targetState$1}), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)updateCount -> updateCount == 1));
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$2(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$4(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$6(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$8(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$10(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$cleanupMetadataByAge$1(JDBCMetadataStore $this, String query$7, long minEndTime$1, long maxAge$1, int limit$1, Connection connection) {
        return BoxesRunTime.unboxToInt($this.withUpdateCount(connection, query$7, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)minEndTime$1), BoxesRunTime.boxToLong((long)minEndTime$1)}), (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)count -> {
            $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(48).append("Cleaned up ").append(count).append(" records older than ").append(maxAge$1).append(" ms from ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" limit:").append(limit$1).append(".").toString());
            return count;
        }));
    }

    public static final /* synthetic */ int $anonfun$cleanupKubernetesEngineInfoByAge$1(JDBCMetadataStore $this, String query$11, long minUpdateTime$1, long maxAge$2, int limit$2, Connection connection) {
        return BoxesRunTime.unboxToInt($this.withUpdateCount(connection, query$11, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)minUpdateTime$1)}), (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)count -> {
            $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(48).append("Cleaned up ").append(count).append(" records older than ").append(maxAge$2).append(" ms from ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$KUBERNETES_ENGINE_INFO_TABLE()).append(" limit ").append(limit$2).append(".").toString());
            return count;
        }));
    }

    public static final /* synthetic */ void $anonfun$setStatementParams$1(PreparedStatement statement$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object param = tuple2._1();
            int index = tuple2._2$mcI$sp();
            Object object = param;
            if (object == null) {
                statement$4.setObject(index + 1, null);
            } else if (object instanceof String) {
                String string = (String)object;
                statement$4.setString(index + 1, string);
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                statement$4.setInt(index + 1, n);
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                statement$4.setLong(index + 1, l);
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                statement$4.setDouble(index + 1, d);
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                statement$4.setFloat(index + 1, f);
            } else if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                statement$4.setBoolean(index + 1, bl);
            } else {
                throw new KyuubiException(new java.lang.StringBuilder(23).append("Unsupported param type ").append(param.getClass().getName()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public JDBCMetadataStore(KyuubiConf conf) {
        block16: {
            GenericDatabaseDialect genericDatabaseDialect;
            String string;
            Logging.$init$((Logging)this);
            this.dbType = DatabaseType$.MODULE$.withName((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_TYPE()));
            this.driverClassOpt = (Option)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DRIVER());
            Enumeration.Value value = this.dbType();
            Enumeration.Value value2 = DatabaseType$.MODULE$.SQLITE();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.sqlite.JDBC");
            } else {
                Enumeration.Value value4 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.mysqlDriverClass());
                } else {
                    Enumeration.Value value6 = DatabaseType$.MODULE$.POSTGRESQL();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.postgresql.Driver");
                    } else {
                        Enumeration.Value value8 = DatabaseType$.MODULE$.CUSTOM();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                throw new IllegalArgumentException("No jdbc driver defined");
                            });
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
            }
            this.driverClass = string;
            Enumeration.Value value10 = this.dbType();
            Enumeration.Value value11 = DatabaseType$.MODULE$.SQLITE();
            Enumeration.Value value12 = value10;
            if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                genericDatabaseDialect = new SQLiteDatabaseDialect();
            } else {
                Enumeration.Value value13 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value14 = value10;
                if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                    genericDatabaseDialect = new MySQLDatabaseDialect();
                } else {
                    Enumeration.Value value15 = DatabaseType$.MODULE$.POSTGRESQL();
                    Enumeration.Value value16 = value10;
                    if (!(value15 != null ? !value15.equals(value16) : value16 != null)) {
                        genericDatabaseDialect = new PostgreSQLDatabaseDialect();
                    } else {
                        Enumeration.Value value17 = DatabaseType$.MODULE$.CUSTOM();
                        Enumeration.Value value18 = value10;
                        if (!(value17 != null ? !value17.equals(value18) : value18 != null)) {
                            genericDatabaseDialect = new GenericDatabaseDialect();
                        } else {
                            throw new MatchError((Object)value10);
                        }
                    }
                }
            }
            this.dialect = genericDatabaseDialect;
            this.priorityEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_PRIORITY_ENABLED()));
            this.datasourceProperties = JDBCMetadataStoreConf$.MODULE$.getMetadataStoreJDBCDataSourceProperties(conf);
            this.hikariConfig = new HikariConfig(this.datasourceProperties());
            this.hikariConfig().setDriverClassName(this.driverClass());
            this.hikariConfig().setJdbcUrl(JDBCMetadataStoreConf$.MODULE$.getMetadataStoreJdbcUrl(conf));
            this.hikariConfig().setUsername((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_USER()));
            this.hikariConfig().setPassword((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_PASSWORD()));
            this.hikariConfig().setPoolName("jdbc-metadata-store-pool");
            this.hikariDataSource = new HikariDataSource(this.hikariConfig());
            this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            if (!BoxesRunTime.unboxToBoolean((Object)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_SCHEMA_INIT()))) break block16;
            this.initSchema();
        }
    }
}

