/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.cli.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kyuubi.shade.io.vertx.core.cli.Argument;
import org.apache.kyuubi.shade.io.vertx.core.cli.CLI;
import org.apache.kyuubi.shade.io.vertx.core.cli.CommandLine;
import org.apache.kyuubi.shade.io.vertx.core.cli.Option;
import org.apache.kyuubi.shade.io.vertx.core.cli.UsageMessageFormatter;
import org.apache.kyuubi.shade.io.vertx.core.cli.impl.DefaultParser;

public class DefaultCLI
implements CLI {
    protected String name;
    protected int priority;
    protected String description;
    protected String summary;
    protected boolean hidden;
    protected List<Option> options = new ArrayList<Option>();
    private List<Argument> arguments = new ArrayList<Argument>();

    @Override
    public CommandLine parse(List<String> arguments) {
        return new DefaultParser().parse(this, arguments);
    }

    @Override
    public CommandLine parse(List<String> arguments, boolean validate) {
        return new DefaultParser().parse(this, arguments, validate);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CLI setName(String name) {
        Objects.requireNonNull(name);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Invalid command name");
        }
        this.name = name;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public CLI setDescription(String desc) {
        Objects.requireNonNull(desc);
        this.description = desc;
        return this;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public CLI setSummary(String summary) {
        Objects.requireNonNull(summary);
        this.summary = summary;
        return this;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public CLI setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public List<Option> getOptions() {
        return this.options;
    }

    @Override
    public CLI addOption(Option option) {
        Objects.requireNonNull(option);
        this.options.add(option);
        return this;
    }

    @Override
    public CLI addOptions(List<Option> options) {
        Objects.requireNonNull(options);
        options.forEach(this::addOption);
        return this;
    }

    @Override
    public CLI setOptions(List<Option> options) {
        Objects.requireNonNull(options);
        this.options = new ArrayList<Option>();
        return this.addOptions(options);
    }

    @Override
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public CLI addArgument(Argument arg) {
        Objects.requireNonNull(arg);
        this.arguments.add(arg);
        return this;
    }

    @Override
    public CLI addArguments(List<Argument> args) {
        Objects.requireNonNull(args);
        args.forEach(this::addArgument);
        return this;
    }

    @Override
    public CLI setArguments(List<Argument> args) {
        Objects.requireNonNull(args);
        this.arguments = new ArrayList<Argument>(args);
        return this;
    }

    @Override
    public Option getOption(String name) {
        Objects.requireNonNull(name);
        List<Predicate> equalityChecks = Arrays.asList(option -> name.equals(option.getLongName()), option -> name.equals(option.getShortName()), option -> name.equals(option.getArgName()), option -> name.equalsIgnoreCase(option.getLongName()), option -> name.equalsIgnoreCase(option.getShortName()), option -> name.equalsIgnoreCase(option.getArgName()));
        for (Predicate equalityCheck : equalityChecks) {
            for (Option option2 : this.options) {
                if (!equalityCheck.test(option2)) continue;
                return option2;
            }
        }
        return null;
    }

    @Override
    public Argument getArgument(String name) {
        Objects.requireNonNull(name);
        for (Argument arg : this.arguments) {
            if (!name.equalsIgnoreCase(arg.getArgName())) continue;
            return arg;
        }
        return null;
    }

    @Override
    public Argument getArgument(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Given index cannot be negative");
        }
        for (Argument arg : this.arguments) {
            if (index != arg.getIndex()) continue;
            return arg;
        }
        return null;
    }

    @Override
    public CLI removeOption(String name) {
        this.options = this.options.stream().filter(o -> !o.getLongName().equals(name) && !o.getShortName().equals(name)).collect(Collectors.toList());
        return this;
    }

    @Override
    public CLI removeArgument(int index) {
        for (Argument arg : new TreeSet<Argument>(this.arguments)) {
            if (arg.getIndex() != index) continue;
            this.arguments.remove(arg);
            return this;
        }
        return this;
    }

    @Override
    public CLI usage(StringBuilder builder) {
        new UsageMessageFormatter().usage(builder, this);
        return this;
    }

    @Override
    public CLI usage(StringBuilder builder, String prefix) {
        new UsageMessageFormatter().usage(builder, prefix, this);
        return this;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public CLI setPriority(int priority) {
        this.priority = priority;
        return this;
    }
}

