/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationManagerInfo;
import org.apache.kyuubi.engine.ApplicationState$;
import org.apache.kyuubi.engine.EngineRef$;
import org.apache.kyuubi.engine.EngineType$;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.chat.ChatProcessBuilder;
import org.apache.kyuubi.engine.flink.FlinkProcessBuilder;
import org.apache.kyuubi.engine.hive.HiveProcessBuilder$;
import org.apache.kyuubi.engine.jdbc.JdbcProcessBuilder$;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder;
import org.apache.kyuubi.engine.trino.TrinoProcessBuilder;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\ted!B\u001b7\u0001ar\u0004\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011E\u0003!\u0011!Q\u0001\nIC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"A\u0001\u000e\u0001B\u0001B\u0003%!\u000b\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003k\u0011!q\u0007A!A!\u0002\u0013y\u0007\"\u0002?\u0001\t\u0003i\b\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011\u001d\t\t\u0002\u0001Q\u0001\nIC\u0011\"a\u0005\u0001\u0005\u0004%I!!\u0006\t\u0011\u0005u\u0001\u0001)A\u0005\u0003/A\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003GA\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u000fB\u0011\"a\u0016\u0001\u0005\u0004%I!!\u0017\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u00037B\u0011\"a\u0019\u0001\u0005\u0004%I!!\u0017\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u00037B\u0011\"a\u001a\u0001\u0005\u0004%I!a\u0004\t\u000f\u0005%\u0004\u0001)A\u0005%\"I\u00111\u000e\u0001C\u0002\u0013%\u0011Q\u000e\u0005\b\u0003_\u0002\u0001\u0015!\u0003_\u0011%\t\t\b\u0001b\u0001\n\u0013\ty\u0001C\u0004\u0002t\u0001\u0001\u000b\u0011\u0002*\t\u0013\u0005U\u0004A1A\u0005\n\u0005]\u0004\u0002CA@\u0001\u0001\u0006I!!\u001f\t\u0017\u0005\u0005\u0005\u00011AA\u0002\u0013%\u00111\u0011\u0005\f\u0003\u0017\u0003\u0001\u0019!a\u0001\n\u0013\ti\tC\u0006\u0002\u001a\u0002\u0001\r\u0011!Q!\n\u0005\u0015\u0005\u0002CAN\u0001\u0011\u0005\u0001(a\u0004\t\u0015\u0005u\u0005A1A\u0005\u0002a\ny\u0001C\u0004\u0002 \u0002\u0001\u000b\u0011\u0002*\t\u0015\u0005\u0005\u0006A1A\u0005\u0002a\ny\u0001C\u0004\u0002$\u0002\u0001\u000b\u0011\u0002*\t\u0015\u0005\u0015\u0006A1A\u0005\u0002a\ny\u0001C\u0004\u0002(\u0002\u0001\u000b\u0011\u0002*\t\u0015\u0005\r\u0007A1A\u0005\u0002a\ny\u0001C\u0004\u0002F\u0002\u0001\u000b\u0011\u0002*\t\u0017\u0005%\u0007\u0001#b\u0001\n\u0003A\u0014q\u0002\u0005\b\u0003\u001b\u0004A\u0011BAh\u0011\u001d\u0011I\u0001\u0001C\u0005\u0005\u0017AqAa\u000b\u0001\t\u0003\u0011i\u0003C\u0005\u00034\u0001\t\n\u0011\"\u0001\u00036!9!1\n\u0001\u0005\u0002\t5\u0003b\u0002B,\u0001\u0011\u0005!\u0011\f\u0005\b\u0005O\u0002A\u0011\u0001B5\u000f)\u0011YGNA\u0001\u0012\u0003A$Q\u000e\u0004\nkY\n\t\u0011#\u00019\u0005_Ba\u0001 \u001a\u0005\u0002\tE\u0004\"\u0003B:eE\u0005I\u0011\u0001B;\u0005%)enZ5oKJ+gM\u0003\u00028q\u00051QM\\4j]\u0016T!!\u000f\u001e\u0002\r-LX/\u001e2j\u0015\tYD(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0005\u0019qN]4\u0014\u0007\u0001yT\t\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015I\u0001\u0004B]f\u0014VM\u001a\t\u0003\r\u001ek\u0011\u0001O\u0005\u0003\u0011b\u0012q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001db\naaY8oM&<\u0017B\u0001)N\u0005)Y\u00150^;cS\u000e{gNZ\u0001\fg\u0016\u001c8/[8o+N,'\u000f\u0005\u0002T5:\u0011A\u000b\u0017\t\u0003+\u0006k\u0011A\u0016\u0006\u0003/*\u000ba\u0001\u0010:p_Rt\u0014BA-B\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\u000b\u0015a\u00033p\u0003N,e.\u00192mK\u0012\u0004\"\u0001Q0\n\u0005\u0001\f%a\u0002\"p_2,\u0017M\\\u0001\u000eOJ|W\u000f\u001d)s_ZLG-\u001a:\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015D\u0014A\u00029mk\u001eLg.\u0003\u0002hI\niqI]8vaB\u0013xN^5eKJ\f1\"\u001a8hS:,'+\u001a4JI\u0006iQM\\4j]\u0016l\u0015M\\1hKJ\u0004\"a\u001b7\u000e\u0003YJ!!\u001c\u001c\u00031-KX/\u001e2j\u0003B\u0004H.[2bi&|g.T1oC\u001e,'/A\fti\u0006\u0014H/\u001e9Qe>\u001cWm]:TK6\f\u0007\u000f[8sKB\u0019\u0001\t\u001d:\n\u0005E\f%AB(qi&|g\u000e\u0005\u0002tu6\tAO\u0003\u0002vm\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005]D\u0018\u0001B;uS2T\u0011!_\u0001\u0005U\u00064\u0018-\u0003\u0002|i\nI1+Z7ba\"|'/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001dy|\u0018\u0011AA\u0002\u0003\u000b\t9!!\u0003\u0002\fA\u00111\u000e\u0001\u0005\u0006\u0013\"\u0001\ra\u0013\u0005\u0006#\"\u0001\rA\u0015\u0005\u0006;\"\u0001\rA\u0018\u0005\u0006C\"\u0001\rA\u0019\u0005\u0006Q\"\u0001\rA\u0015\u0005\u0006S\"\u0001\rA\u001b\u0005\b]\"\u0001\n\u00111\u0001p\u0003-\u0019XM\u001d<feN\u0003\u0018mY3\u0016\u0003I\u000bAb]3sm\u0016\u00148\u000b]1dK\u0002\nq\u0001^5nK>,H/\u0006\u0002\u0002\u0018A\u0019\u0001)!\u0007\n\u0007\u0005m\u0011I\u0001\u0003M_:<\u0017\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\u0002\u0015MD\u0017M]3MKZ,G.\u0006\u0002\u0002$A!\u0011QEA\u001e\u001d\u0011\t9#a\u000e\u000f\t\u0005%\u0012Q\u0007\b\u0005\u0003W\t\u0019D\u0004\u0003\u0002.\u0005EbbA+\u00020%\tQ(\u0003\u0002<y%\u0011\u0011HO\u0005\u0003oaJ1!!\u000f7\u0003)\u0019\u0006.\u0019:f\u0019\u00164X\r\\\u0005\u0005\u0003{\tyD\u0001\u0006TQ\u0006\u0014X\rT3wK2T1!!\u000f7\u0003-\u0019\b.\u0019:f\u0019\u00164X\r\u001c\u0011\u0002\u0015\u0015tw-\u001b8f)f\u0004X-\u0006\u0002\u0002HA!\u0011\u0011JA(\u001d\u0011\t9#a\u0013\n\u0007\u00055c'\u0001\u0006F]\u001eLg.\u001a+za\u0016LA!!\u0015\u0002T\tQQI\\4j]\u0016$\u0016\u0010]3\u000b\u0007\u00055c'A\u0006f]\u001eLg.\u001a+za\u0016\u0004\u0013!\u00049p_2$\u0006N]3tQ>dG-\u0006\u0002\u0002\\A\u0019\u0001)!\u0018\n\u0007\u0005}\u0013IA\u0002J]R\fa\u0002]8pYRC'/Z:i_2$\u0007%\u0001\bdY&,g\u000e\u001e)p_2\u001c\u0016N_3\u0002\u001f\rd\u0017.\u001a8u!>|GnU5{K\u0002\nab\u00197jK:$\bk\\8m\u001d\u0006lW-A\bdY&,g\u000e\u001e)p_2t\u0015-\\3!\u0003e)gnZ5oKB{w\u000e\\%h]>\u0014XmU;cI>l\u0017-\u001b8\u0016\u0003y\u000b!$\u001a8hS:,\u0007k\\8m\u0013\u001etwN]3Tk\n$w.\\1j]\u0002\na#\u001a8hS:,\u0007k\\8m'\u0016dWm\u0019;Q_2L7-_\u0001\u0018K:<\u0017N\\3Q_>d7+\u001a7fGR\u0004v\u000e\\5ds\u0002\n\u0001\u0004T(D\u0017~#\u0016*T#P+R{6\u000bU!O?\u001a\u000b5\tV(S+\t\tI\bE\u0002A\u0003wJ1!! B\u0005\u0019!u.\u001e2mK\u0006IBjT\"L?RKU*R(V)~\u001b\u0006+\u0011(`\r\u0006\u001bEk\u0014*!\u0003\u001d\u0011W/\u001b7eKJ,\"!!\"\u0011\u0007-\f9)C\u0002\u0002\nZ\u00121\u0002\u0015:pG\n+\u0018\u000e\u001c3fe\u0006Y!-^5mI\u0016\u0014x\fJ3r)\u0011\ty)!&\u0011\u0007\u0001\u000b\t*C\u0002\u0002\u0014\u0006\u0013A!\u00168ji\"I\u0011q\u0013\u0010\u0002\u0002\u0003\u0007\u0011QQ\u0001\u0004q\u0012\n\u0014\u0001\u00032vS2$WM\u001d\u0011\u0002\u001d\u001d,G/\u00128hS:,'+\u001a4JI\u0006Y!o\\;uS:<Wk]3s\u00031\u0011x.\u001e;j]\u001e,6/\u001a:!\u0003\u001d\t\u0007\u000f]+tKJ\f\u0001\"\u00199q+N,'\u000fI\u0001\ngV\u0014Gm\\7bS:\f!b];cI>l\u0017-\u001b8!Q\r1\u00131\u0016\t\u0005\u0003[\u000by,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003-\tgN\\8uCRLwN\\:\u000b\t\u0005U\u0016qW\u0001\u0007G>lWn\u001c8\u000b\t\u0005e\u00161X\u0001\u0007O>|w\r\\3\u000b\u0005\u0005u\u0016aA2p[&!\u0011\u0011YAX\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\u0001\u0012I\u00164\u0017-\u001e7u\u000b:<\u0017N\\3OC6,\u0017A\u00053fM\u0006,H\u000e^#oO&tWMT1nK\u0002B3\u0001KAV\u0003-)gnZ5oKN\u0003\u0018mY3)\u0007%\nY+A\u0006uef<\u0016\u000e\u001e5M_\u000e\\W\u0003BAi\u00033$B!a5\u0002vR!\u0011Q[Av!\u0011\t9.!7\r\u0001\u00119\u00111\u001c\u0016C\u0002\u0005u'!\u0001+\u0012\t\u0005}\u0017Q\u001d\t\u0004\u0001\u0006\u0005\u0018bAAr\u0003\n9aj\u001c;iS:<\u0007c\u0001!\u0002h&\u0019\u0011\u0011^!\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002n*\"\t\u0019AAx\u0003\u00051\u0007#\u0002!\u0002r\u0006U\u0017bAAz\u0003\nAAHY=oC6,g\bC\u0004\u0002x*\u0002\r!!?\u0002\u001f\u0011L7oY8wKJL8\t\\5f]R\u0004B!a?\u0003\u00065\u0011\u0011Q \u0006\u0005\u0003\u007f\u0014\t!\u0001\u0004dY&,g\u000e\u001e\u0006\u0004\u0005\u0007A\u0014A\u00015b\u0013\u0011\u00119!!@\u0003\u001f\u0011K7oY8wKJL8\t\\5f]R\faa\u0019:fCR,GC\u0002B\u0007\u0005'\u0011)\u0002\u0005\u0004A\u0005\u001f\u0011\u00161L\u0005\u0004\u0005#\t%A\u0002+va2,'\u0007C\u0004\u0002x.\u0002\r!!?\t\u000f\t]1\u00061\u0001\u0003\u001a\u0005qQ\r\u001f;sC\u0016sw-\u001b8f\u0019><\u0007\u0003\u0002!q\u00057\u0001BA!\b\u0003(5\u0011!q\u0004\u0006\u0005\u0005C\u0011\u0019#A\u0002m_\u001eT1A!\n9\u0003%y\u0007/\u001a:bi&|g.\u0003\u0003\u0003*\t}!\u0001D(qKJ\fG/[8o\u0019><\u0017aC4fi>\u00138I]3bi\u0016$bA!\u0004\u00030\tE\u0002bBA|Y\u0001\u0007\u0011\u0011 \u0005\n\u0005/a\u0003\u0013!a\u0001\u00053\tQcZ3u\u001fJ\u001c%/Z1uK\u0012\"WMZ1vYR$#'\u0006\u0002\u00038)\"!\u0011\u0004B\u001dW\t\u0011Y\u0004\u0005\u0003\u0003>\t\u001dSB\u0001B \u0015\u0011\u0011\tEa\u0011\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B#\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%#q\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00033fe\u0016<\u0017n\u001d;feR1!q\nB)\u0005'\u0002R\u0001\u0011B\b=JCq!a>/\u0001\u0004\tI\u0010C\u0004\u0003V9\u0002\rA!\u0004\u0002\u0011!|7\u000f\u001e)peR\fabZ3u'\u0016\u0014h/[2f\u001d>$W\r\u0006\u0004\u0003\\\t\r$Q\r\t\u0005\u0001B\u0014i\u0006\u0005\u0003\u0002|\n}\u0013\u0002\u0002B1\u0003{\u0014qbU3sm&\u001cWMT8eK&sgm\u001c\u0005\b\u0003o|\u0003\u0019AA}\u0011\u001d\u0011)f\fa\u0001\u0005\u001b\tQa\u00197pg\u0016$\"!a$\u0002\u0013\u0015sw-\u001b8f%\u00164\u0007CA63'\t\u0011t\b\u0006\u0002\u0003n\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"Aa\u001e+\u0007=\u0014I\u0004")
public class EngineRef
implements Logging {
    @VisibleForTesting
    private String engineSpace;
    private final KyuubiConf conf;
    private final boolean doAsEnabled;
    private final String engineRefId;
    private final KyuubiApplicationManager engineManager;
    private final Option<Semaphore> startupProcessSemaphore;
    private final String serverSpace;
    private final long timeout;
    private final Enumeration.Value shareLevel;
    private final Enumeration.Value engineType;
    private final int poolThreshold;
    private final int clientPoolSize;
    private final String clientPoolName;
    private final boolean enginePoolIgnoreSubdomain;
    private final String enginePoolSelectPolicy;
    private final double LOCK_TIMEOUT_SPAN_FACTOR;
    private ProcBuilder builder;
    private final String routingUser;
    private final String appUser;
    @VisibleForTesting
    private final String subdomain;
    @VisibleForTesting
    private final String defaultEngineName;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Option<Semaphore> $lessinit$greater$default$7() {
        return EngineRef$.MODULE$.$lessinit$greater$default$7();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private String serverSpace() {
        return this.serverSpace;
    }

    private long timeout() {
        return this.timeout;
    }

    private Enumeration.Value shareLevel() {
        return this.shareLevel;
    }

    private Enumeration.Value engineType() {
        return this.engineType;
    }

    private int poolThreshold() {
        return this.poolThreshold;
    }

    private int clientPoolSize() {
        return this.clientPoolSize;
    }

    private String clientPoolName() {
        return this.clientPoolName;
    }

    private boolean enginePoolIgnoreSubdomain() {
        return this.enginePoolIgnoreSubdomain;
    }

    private String enginePoolSelectPolicy() {
        return this.enginePoolSelectPolicy;
    }

    private double LOCK_TIMEOUT_SPAN_FACTOR() {
        return this.LOCK_TIMEOUT_SPAN_FACTOR;
    }

    private ProcBuilder builder() {
        return this.builder;
    }

    private void builder_$eq(ProcBuilder x$1) {
        this.builder = x$1;
    }

    public String getEngineRefId() {
        return this.engineRefId;
    }

    public String routingUser() {
        return this.routingUser;
    }

    public String appUser() {
        return this.appUser;
    }

    public String subdomain() {
        return this.subdomain;
    }

    public String defaultEngineName() {
        return this.defaultEngineName;
    }

    private String engineSpace$lzycompute() {
        EngineRef engineRef = this;
        synchronized (engineRef) {
            if (!this.bitmap$0) {
                String commonParent = new StringBuilder(3).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).toString();
                Enumeration.Value value = this.shareLevel();
                Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
                Enumeration.Value value3 = value;
                this.engineSpace = !(value2 != null ? !value2.equals(value3) : value3 != null) ? DiscoveryPaths$.MODULE$.makePath(commonParent, this.routingUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.engineRefId})) : DiscoveryPaths$.MODULE$.makePath(commonParent, this.routingUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.subdomain()}));
                this.bitmap$0 = true;
            }
        }
        return this.engineSpace;
    }

    public String engineSpace() {
        if (!this.bitmap$0) {
            return this.engineSpace$lzycompute();
        }
        return this.engineSpace;
    }

    private <T> T tryWithLock(DiscoveryClient discoveryClient, Function0<T> f) {
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (T)f.apply();
        }
        String lockPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(8).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_lock").toString(), this.routingUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.subdomain()}));
        return (T)discoveryClient.tryWithLock(lockPath, this.timeout() + (long)(this.LOCK_TIMEOUT_SPAN_FACTOR() * (double)this.timeout()), f);
    }

    private Tuple2<String, Object> create(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            tuple2 = (Tuple2)this.tryWithLock(discoveryClient, (Function0 & Serializable & scala.Serializable)() -> {
                boolean waitCompletion;
                boolean destroyProcess;
                Tuple2 tuple2;
                Logging logging;
                Option engineRef = discoveryClient.getServerHost(this.engineSpace());
                if (engineRef.nonEmpty()) {
                    throw new NonLocalReturnControl(object, engineRef.get());
                }
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_NAMESPACE(), (Object)this.engineSpace());
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID(), (Object)$this.engineRefId);
                long started = System.currentTimeMillis();
                $this.conf.set("kyuubi.engine.submit.time", String.valueOf(started));
                Enumeration.Value value = this.engineType();
                Enumeration.Value value2 = EngineType$.MODULE$.SPARK_SQL();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    $this.conf.setIfMissing("spark.app.name", this.defaultEngineName());
                    logging = new SparkProcessBuilder(this.appUser(), $this.doAsEnabled, $this.conf, $this.engineRefId, extraEngineLog);
                } else {
                    Enumeration.Value value4 = EngineType$.MODULE$.FLINK_SQL();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        $this.conf.setIfMissing("flink.app.name", this.defaultEngineName());
                        logging = new FlinkProcessBuilder(this.appUser(), $this.doAsEnabled, $this.conf, $this.engineRefId, extraEngineLog);
                    } else {
                        Enumeration.Value value6 = EngineType$.MODULE$.TRINO();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            logging = new TrinoProcessBuilder(this.appUser(), $this.doAsEnabled, $this.conf, $this.engineRefId, extraEngineLog);
                        } else {
                            Enumeration.Value value8 = EngineType$.MODULE$.HIVE_SQL();
                            Enumeration.Value value9 = value;
                            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                $this.conf.setIfMissing("hive.engine.name", this.defaultEngineName());
                                logging = HiveProcessBuilder$.MODULE$.apply(this.appUser(), $this.doAsEnabled, $this.conf, $this.engineRefId, extraEngineLog, this.defaultEngineName());
                            } else {
                                Enumeration.Value value10 = EngineType$.MODULE$.JDBC();
                                Enumeration.Value value11 = value;
                                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                    $this.conf.setIfMissing("jdbc.engine.name", this.defaultEngineName());
                                    logging = JdbcProcessBuilder$.MODULE$.apply(this.appUser(), $this.doAsEnabled, $this.conf, $this.engineRefId, extraEngineLog, this.defaultEngineName());
                                } else {
                                    Enumeration.Value value12 = EngineType$.MODULE$.CHAT();
                                    Enumeration.Value value13 = value;
                                    if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                        logging = new ChatProcessBuilder(this.appUser(), $this.doAsEnabled, $this.conf, $this.engineRefId, extraEngineLog);
                                    } else {
                                        throw new MatchError((Object)value);
                                    }
                                }
                            }
                        }
                    }
                }
                this.builder_$eq((ProcBuilder)logging);
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.incCount(MetricsConstants$.MODULE$.ENGINE_TOTAL());
                    return BoxedUnit.UNIT;
                });
                boolean acquiredPermit = false;
                try {
                    if (!$this.startupProcessSemaphore.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.tryAcquire(this.timeout(), TimeUnit.MILLISECONDS)))) {
                        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$4 -> {
                            x$4.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                            return BoxedUnit.UNIT;
                        });
                        throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(94).append("Timeout(").append(this.timeout()).append(" ms, you can modify ").append(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT().key()).append(" to change it) to").append(" acquires a permit from engine builder semaphore.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                    }
                    acquiredPermit = true;
                    String redactedCmd = this.builder().toString();
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Launching engine:\n").append(redactedCmd).toString());
                    this.builder().validateConf();
                    Process process = this.builder().start();
                    None$ exitValue = None$.MODULE$;
                    ObjectRef lastApplicationInfo = ObjectRef.create((Object)None$.MODULE$);
                    while (engineRef.isEmpty()) {
                        if (exitValue.isEmpty() && process.waitFor(1L, TimeUnit.SECONDS)) {
                            exitValue = new Some((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
                            if (exitValue.contains((Object)BoxesRunTime.boxToInteger((int)0))) {
                                acquiredPermit = false;
                                $this.startupProcessSemaphore.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                                    x$5.release();
                                    return BoxedUnit.UNIT;
                                });
                            } else {
                                Throwable error = this.builder().getError();
                                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                                    EngineRef.$anonfun$create$7(this, error, ms);
                                    return BoxedUnit.UNIT;
                                });
                                throw error;
                            }
                        }
                        if (started + this.timeout() <= System.currentTimeMillis()) {
                            Tuple2<Object, String> killMessage = $this.engineManager.killApplication(this.builder().appMgrInfo(), $this.engineRefId, (Option<String>)new Some((Object)this.appUser()));
                            this.builder().close(true);
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$6 -> {
                                x$6.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                                return BoxedUnit.UNIT;
                            });
                            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(70).append("Timeout(").append(this.timeout()).append(" ms, you can modify ").append(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT().key()).append(" to change it) to").append(" launched ").append(this.engineType()).append(" engine with ").append(redactedCmd).append(". ").append(killMessage).toString(), this.builder().getError(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                        }
                        engineRef = discoveryClient.getEngineByRefId(this.engineSpace(), $this.engineRefId);
                        if (!engineRef.isEmpty() || !exitValue.contains((Object)BoxesRunTime.boxToInteger((int)0))) continue;
                        Option$.MODULE$.apply((Object)$this.engineManager).foreach((Function1 & Serializable & scala.Serializable)engineMgr -> {
                            EngineRef.$anonfun$create$9(this, lastApplicationInfo, started, engineMgr);
                            return BoxedUnit.UNIT;
                        });
                    }
                    tuple2 = (Tuple2)engineRef.get();
                }
                catch (Throwable throwable) {
                    boolean waitCompletion2;
                    boolean destroyProcess2;
                    if (acquiredPermit) {
                        $this.startupProcessSemaphore.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                            x$7.release();
                            return BoxedUnit.UNIT;
                        });
                    }
                    boolean bl = destroyProcess2 = !(waitCompletion2 = BoxesRunTime.unboxToBoolean((Object)$this.conf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_STARTUP_WAIT_COMPLETION()))) && this.builder().isClusterMode();
                    if (destroyProcess2) {
                        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Destroy the builder process because waitCompletion is false and the engine is running in cluster mode.");
                    }
                    this.builder().close(destroyProcess2);
                    throw throwable;
                }
                if (acquiredPermit) {
                    $this.startupProcessSemaphore.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                        x$7.release();
                        return BoxedUnit.UNIT;
                    });
                }
                boolean bl = destroyProcess = !(waitCompletion = BoxesRunTime.unboxToBoolean((Object)$this.conf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_STARTUP_WAIT_COMPLETION()))) && this.builder().isClusterMode();
                if (destroyProcess) {
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Destroy the builder process because waitCompletion is false and the engine is running in cluster mode.");
                }
                this.builder().close(destroyProcess);
                return tuple2;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public Tuple2<String, Object> getOrCreate(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        return (Tuple2)discoveryClient.getServerHost(this.engineSpace()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.create(discoveryClient, extraEngineLog));
    }

    public Option<OperationLog> getOrCreate$default$2() {
        return None$.MODULE$;
    }

    public Tuple2<Object, String> deregister(DiscoveryClient discoveryClient, Tuple2<String, Object> hostPort) {
        return (Tuple2)this.tryWithLock(discoveryClient, (Function0 & Serializable & scala.Serializable)() -> {
            Seq seq = discoveryClient.getServiceNodesInfo(this.engineSpace(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), true);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                ServiceNodeInfo sn = (ServiceNodeInfo)((SeqLike)some.get()).apply(0);
                Tuple2 tuple2 = new Tuple2((Object)sn.host(), (Object)BoxesRunTime.boxToInteger((int)sn.port()));
                Tuple2 tuple22 = hostPort;
                if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                    String msg = new StringBuilder(21).append("Deleting engine node:").append(sn).toString();
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> msg);
                    discoveryClient.delete(new StringBuilder(1).append(this.engineSpace()).append("/").append(sn.nodeName()).toString(), discoveryClient.delete$default$2());
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
                }
                String msg = new StringBuilder(44).append("Engine node:").append(sn).append(" is not matched with host&port[").append(hostPort).append("]").toString();
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> msg);
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)msg);
            }
            String msg = new StringBuilder(24).append("No engine node found in ").append(this.engineSpace()).toString();
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> msg);
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)msg);
        });
    }

    public Option<ServiceNodeInfo> getServiceNode(DiscoveryClient discoveryClient, Tuple2<String, Object> hostPort) {
        Seq serviceNodes = discoveryClient.getServiceNodesInfo(this.engineSpace(), discoveryClient.getServiceNodesInfo$default$2(), discoveryClient.getServiceNodesInfo$default$3());
        return serviceNodes.find((Function1 & Serializable & scala.Serializable)sn -> BoxesRunTime.boxToBoolean((boolean)EngineRef.$anonfun$getServiceNode$1(hostPort, sn)));
    }

    public void close() {
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        if (!(value != null ? !value.equals(value2) : value2 != null) && this.builder() != null) {
            try {
                ApplicationManagerInfo appMgrInfo = this.builder().appMgrInfo();
                this.builder().close(true);
                this.engineManager.killApplication(appMgrInfo, this.engineRefId, (Option<String>)new Some((Object)this.appUser()));
            }
            catch (Exception e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error closing engine builder, engineRefId: ").append($this.engineRefId).toString(), e);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$create$7(EngineRef $this, Throwable error$1, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{error$1.getClass().getSimpleName()}));
    }

    public static final /* synthetic */ void $anonfun$create$11(EngineRef $this, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{"ENGINE_TERMINATE"}));
    }

    public static final /* synthetic */ void $anonfun$create$10(EngineRef $this, ApplicationInfo appInfo) {
        if (ApplicationState$.MODULE$.isTerminated(appInfo.state())) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                EngineRef.$anonfun$create$11($this, ms);
                return BoxedUnit.UNIT;
            });
            throw new KyuubiSQLException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(158).append("\n                     |The engine application has been terminated. Please check the engine log.\n                     |ApplicationInfo: ").append(appInfo.toMap().mkString("(\n", ",\n", "\n)")).append("\n                     |").toString())).stripMargin(), $this.builder().getError());
        }
    }

    public static final /* synthetic */ void $anonfun$create$9(EngineRef $this, ObjectRef lastApplicationInfo$1, long started$1, KyuubiApplicationManager engineMgr) {
        if (((Option)lastApplicationInfo$1.elem).isDefined()) {
            TimeUnit.SECONDS.sleep(1L);
        }
        Option<ApplicationInfo> applicationInfo = engineMgr.getApplicationInfo($this.builder().appMgrInfo(), $this.engineRefId, (Option<String>)new Some((Object)$this.appUser()), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)started$1)));
        applicationInfo.foreach((Function1 & Serializable & scala.Serializable)appInfo -> {
            EngineRef.$anonfun$create$10($this, appInfo);
            return BoxedUnit.UNIT;
        });
        lastApplicationInfo$1.elem = applicationInfo;
    }

    public static final /* synthetic */ boolean $anonfun$getServiceNode$1(Tuple2 hostPort$2, ServiceNodeInfo sn) {
        Tuple2 tuple2 = new Tuple2((Object)sn.host(), (Object)BoxesRunTime.boxToInteger((int)sn.port()));
        Tuple2 tuple22 = hostPort$2;
        return !(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null);
    }

    public EngineRef(KyuubiConf conf, String sessionUser, boolean doAsEnabled, GroupProvider groupProvider, String engineRefId, KyuubiApplicationManager engineManager, Option<Semaphore> startupProcessSemaphore) {
        String string;
        String string2;
        this.conf = conf;
        this.doAsEnabled = doAsEnabled;
        this.engineRefId = engineRefId;
        this.engineManager = engineManager;
        this.startupProcessSemaphore = startupProcessSemaphore;
        Logging.$init$((Logging)this);
        this.serverSpace = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE());
        this.timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.shareLevel = ShareLevel$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL()));
        this.engineType = EngineType$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()));
        this.poolThreshold = BoxesRunTime.unboxToInt((Object)((KyuubiConf)Option$.MODULE$.apply((Object)engineManager).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getConf()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1()))).get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE_THRESHOLD()));
        this.clientPoolSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE()));
        this.clientPoolName = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_NAME());
        this.enginePoolIgnoreSubdomain = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_IGNORE_SUBDOMAIN()));
        this.enginePoolSelectPolicy = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SELECT_POLICY());
        this.LOCK_TIMEOUT_SPAN_FACTOR = Utils$.MODULE$.isTesting() ? 0.5 : 0.1;
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.SERVER();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string2 = Utils$.MODULE$.currentUser();
        } else {
            Enumeration.Value value4 = ShareLevel$.MODULE$.GROUP();
            Enumeration.Value value5 = value;
            string2 = !(value4 != null ? !value4.equals(value5) : value5 != null) ? groupProvider.primaryGroup(sessionUser, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)conf.getAll()).asJava()) : sessionUser;
        }
        this.routingUser = string2;
        this.appUser = doAsEnabled ? this.routingUser() : Utils$.MODULE$.currentUser();
        Option option = (Option)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN());
        if (this.clientPoolSize() > 0 && (option.isEmpty() || this.enginePoolIgnoreSubdomain())) {
            int n;
            String string3;
            int poolSize = scala.math.package$.MODULE$.min(this.clientPoolSize(), this.poolThreshold());
            if (poolSize < this.clientPoolSize()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Request engine pool size(").append(this.clientPoolSize()).append(") exceeds, fallback to ").append("system threshold ").append(this.poolThreshold()).toString());
            }
            if ("POLLING".equals(string3 = this.enginePoolSelectPolicy())) {
                String snPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(10).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_seqNum").toString(), this.routingUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.clientPoolName()}));
                n = BoxesRunTime.unboxToInt((Object)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(conf, (Function1 & Serializable & scala.Serializable)client -> BoxesRunTime.boxToInteger((int)client.getAndIncrement(snPath, client.getAndIncrement$default$2()))));
            } else if ("RANDOM".equals(string3)) {
                n = Random$.MODULE$.nextInt(poolSize);
            } else {
                throw new MatchError((Object)string3);
            }
            int seqNum = n;
            string = new StringBuilder(1).append(this.clientPoolName()).append("-").append(seqNum % poolSize).toString();
        } else if (option instanceof Some) {
            String _subdomain;
            Some some = (Some)option;
            string = _subdomain = (String)some.value();
        } else {
            string = "default";
        }
        this.subdomain = string;
        String commonNamePrefix = new StringBuilder(9).append("kyuubi_").append(this.shareLevel()).append("_").append(this.engineType()).append("_").append(this.routingUser()).toString();
        Enumeration.Value value6 = this.shareLevel();
        Enumeration.Value value7 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value8 = value6;
        this.defaultEngineName = !(value7 != null ? !value7.equals(value8) : value8 != null) ? new StringBuilder(1).append(commonNamePrefix).append("_").append(engineRefId).toString() : new StringBuilder(2).append(commonNamePrefix).append("_").append(this.subdomain()).append("_").append(engineRefId).toString();
    }
}

