/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.ldaptive.provider.ConnectionFactoryMetadata;
import org.ldaptive.provider.ConnectionStrategy;

public final class ConnectionStrategies {
    private ConnectionStrategies() {
    }

    protected static List<String> splitLdapUrl(String url) {
        ArrayList<String> urls = new ArrayList<String>();
        if (url != null) {
            StringTokenizer st = new StringTokenizer(url);
            while (st.hasMoreTokens()) {
                urls.add(st.nextToken());
            }
        } else {
            urls.add(null);
        }
        return urls;
    }

    public static class RandomConnectionStrategy
    implements ConnectionStrategy {
        @Override
        public String[] getLdapUrls(ConnectionFactoryMetadata metadata) {
            List<String> l = ConnectionStrategies.splitLdapUrl(metadata.getLdapUrl());
            Collections.shuffle(l);
            return l.toArray(new String[l.size()]);
        }
    }

    public static class RoundRobinConnectionStrategy
    implements ConnectionStrategy {
        private int invocationCount;
        private final boolean useConnectionCount;

        public RoundRobinConnectionStrategy() {
            this(true);
        }

        public RoundRobinConnectionStrategy(boolean b) {
            this.useConnectionCount = b;
        }

        @Override
        public String[] getLdapUrls(ConnectionFactoryMetadata metadata) {
            List<String> l = ConnectionStrategies.splitLdapUrl(metadata.getLdapUrl());
            int count = this.getCount(metadata.getConnectionCount());
            for (int i = 0; i < count % l.size(); ++i) {
                l.add(l.remove(0));
            }
            return l.toArray(new String[l.size()]);
        }

        protected int getCount(int connectionCount) {
            if (this.useConnectionCount) {
                return connectionCount;
            }
            return this.returnAndIncrementInvocationCount();
        }

        private int returnAndIncrementInvocationCount() {
            int i = this.invocationCount++;
            if (this.invocationCount < 0) {
                this.invocationCount = 0;
            }
            return i;
        }
    }

    public static class ActivePassiveConnectionStrategy
    implements ConnectionStrategy {
        @Override
        public String[] getLdapUrls(ConnectionFactoryMetadata metadata) {
            List<String> l = ConnectionStrategies.splitLdapUrl(metadata.getLdapUrl());
            return l.toArray(new String[l.size()]);
        }
    }

    public static class DefaultConnectionStrategy
    implements ConnectionStrategy {
        @Override
        public String[] getLdapUrls(ConnectionFactoryMetadata metadata) {
            return new String[]{metadata.getLdapUrl()};
        }
    }
}

