/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.monitor;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.topology.discovery.ClusterConfigurationMonitor;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerCluster;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ClusterConfigurationCache;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ClusterConfigurationFileStore;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ClusterConfigurationStore;
import org.apache.knox.gateway.topology.discovery.cm.monitor.DiscoveryConfigurationFileStore;
import org.apache.knox.gateway.topology.discovery.cm.monitor.DiscoveryConfigurationStore;
import org.apache.knox.gateway.topology.discovery.cm.monitor.PollingConfigurationAnalyzer;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ServiceConfigurationModel;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ServiceConfigurationRecord;

public class ClouderaManagerClusterConfigurationMonitor
implements ClusterConfigurationMonitor,
ClusterConfigurationMonitor.ConfigurationChangeListener {
    private static final String TYPE = "CM";
    private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    private PollingConfigurationAnalyzer internalMonitor;
    private final List<ClusterConfigurationMonitor.ConfigurationChangeListener> changeListeners = new ArrayList<ClusterConfigurationMonitor.ConfigurationChangeListener>();
    private ClusterConfigurationCache configCache = new ClusterConfigurationCache();
    private DiscoveryConfigurationStore discoveryConfigStore;
    private ClusterConfigurationStore serviceConfigStore;
    private ExecutorService executorService;

    public static String getType() {
        return TYPE;
    }

    ClouderaManagerClusterConfigurationMonitor(GatewayConfig config, AliasService aliasService, KeystoreService keystoreService) {
        this.discoveryConfigStore = new DiscoveryConfigurationFileStore(config);
        this.serviceConfigStore = new ClusterConfigurationFileStore(config);
        BasicThreadFactory tf = new BasicThreadFactory.Builder().namingPattern("ClouderaManagerConfigurationMonitor-%d").build();
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)tf);
        this.internalMonitor = new PollingConfigurationAnalyzer(this.configCache, aliasService, keystoreService, this);
        int interval = config.getClusterMonitorPollingInterval(ClouderaManagerClusterConfigurationMonitor.getType());
        if (interval > 0) {
            this.setPollingInterval(interval);
        }
        this.loadDiscoveryConfiguration();
        this.loadServiceConfiguration();
    }

    public void start() {
        log.startingClouderaManagerConfigMonitor();
        this.executorService.execute(this.internalMonitor);
    }

    public void stop() {
        log.stoppingClouderaManagerConfigMonitor();
        this.internalMonitor.stop();
    }

    public void setPollingInterval(int interval) {
        this.internalMonitor.setInterval(interval);
    }

    public void addListener(ClusterConfigurationMonitor.ConfigurationChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void addServiceConfiguration(ClouderaManagerCluster cluster, ServiceDiscoveryConfig discoveryConfig) {
        String address = discoveryConfig.getAddress();
        String clusterName = cluster.getName();
        this.internalMonitor.setEventQueryTimestamp(address, clusterName, Instant.now());
        this.discoveryConfigStore.store(discoveryConfig);
        this.configCache.addDiscoveryConfig(discoveryConfig);
        Map<String, List<ServiceModel>> serviceModels = cluster.getServiceModels();
        HashMap<String, ServiceConfigurationModel> scpMap = new HashMap<String, ServiceConfigurationModel>();
        for (String service : serviceModels.keySet()) {
            for (ServiceModel model : serviceModels.get(service)) {
                ServiceConfigurationModel scp = scpMap.computeIfAbsent(model.getServiceType(), p -> new ServiceConfigurationModel());
                Map<String, String> serviceProps = model.getServiceProperties();
                for (Map.Entry<String, String> entry : serviceProps.entrySet()) {
                    scp.addServiceProperty(entry.getKey(), entry.getValue());
                }
                Map<String, Map<String, String>> roleProps = model.getRoleProperties();
                for (String roleName : roleProps.keySet()) {
                    Map<String, String> rp = roleProps.get(roleName);
                    for (Map.Entry<String, String> entry : rp.entrySet()) {
                        scp.addRoleProperty(roleName, entry.getKey(), entry.getValue());
                    }
                }
            }
        }
        this.serviceConfigStore.store(address, clusterName, scpMap);
        this.configCache.addServiceConfiguration(address, clusterName, scpMap);
    }

    private void loadDiscoveryConfiguration() {
        for (ServiceDiscoveryConfig sdc : this.discoveryConfigStore.getAll()) {
            this.configCache.addDiscoveryConfig(sdc);
        }
    }

    private void loadServiceConfiguration() {
        for (ServiceConfigurationRecord record : this.serviceConfigStore.getAll()) {
            this.configCache.addServiceConfiguration(record.getDiscoveryAddress(), record.getClusterName(), record.getConfigs());
        }
    }

    public void clearCache(String source, String clusterName) {
        this.configCache.removeServiceConfiguration(source, clusterName);
        this.serviceConfigStore.remove(source, clusterName);
    }

    public void onConfigurationChange(String source, String clusterName) {
        this.notifyChangeListeners(source, clusterName);
    }

    private void notifyChangeListeners(String source, String clusterName) {
        for (ClusterConfigurationMonitor.ConfigurationChangeListener listener : this.changeListeners) {
            listener.onConfigurationChange(source, clusterName);
        }
    }
}

