/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.FreeLogicalRowIdPage;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowId;
import jdbm.recman.RecordFile;

final class FreeLogicalRowIdPageManager {
    private RecordFile recordFile;
    private PageManager pageManager;

    FreeLogicalRowIdPageManager(PageManager pageManager) throws IOException {
        this.pageManager = pageManager;
        this.recordFile = pageManager.getRecordFile();
    }

    Location get() throws IOException {
        PageCursor cursor = new PageCursor(this.pageManager, 3);
        while (cursor.next() != 0L) {
            BlockIo blockIo = this.recordFile.get(cursor.getBlockId());
            FreeLogicalRowIdPage fp = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(blockIo);
            int slot = fp.getFirstAllocated();
            if (slot != -1) {
                Location location = new Location(fp.get(slot));
                fp.free(slot);
                boolean hasMore = fp.getCount() != 0;
                this.recordFile.release(cursor.getBlockId(), hasMore);
                if (!hasMore) {
                    this.pageManager.free((short)3, cursor.getBlockId());
                }
                return location;
            }
            this.recordFile.release(cursor.getBlockId(), false);
        }
        return null;
    }

    void put(Location rowId) throws IOException {
        FreeLogicalRowIdPage fp;
        BlockIo curBlockIo;
        PhysicalRowId free = null;
        PageCursor curs = new PageCursor(this.pageManager, 3);
        long freePage = 0L;
        while (curs.next() != 0L) {
            freePage = curs.getBlockId();
            curBlockIo = this.recordFile.get(freePage);
            fp = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(curBlockIo);
            int slot = fp.getFirstFree();
            if (slot != -1) {
                free = fp.alloc(slot);
                break;
            }
            this.recordFile.release(curBlockIo);
        }
        if (free == null) {
            freePage = this.pageManager.allocate((short)3);
            curBlockIo = this.recordFile.get(freePage);
            fp = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(curBlockIo);
            free = fp.alloc(0);
        }
        free.setBlock(rowId.getBlock());
        free.setOffset(rowId.getOffset());
        this.recordFile.release(freePage, true);
    }
}

