/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4jv2;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.ops4j.pax.logging.OSGIPaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.log4jv2.Log4jv2Logger;
import org.osgi.framework.BundleContext;

public class Log4jv2LoggerContext
implements LoggerContext {
    private static final ConcurrentMap<String, Log4jv2Logger> loggers = new ConcurrentHashMap<String, Log4jv2Logger>();
    private static PaxLoggingManager paxLogging;

    public static void setBundleContext(BundleContext ctx) {
        paxLogging = new OSGIPaxLoggingManager(ctx);
        for (Log4jv2Logger logger : loggers.values()) {
            logger.setPaxLoggingManager(paxLogging);
        }
        paxLogging.open();
    }

    public static void dispose() {
    }

    @Override
    public ExtendedLogger getLogger(String name) {
        return this.getLogger(name, null);
    }

    @Override
    public ExtendedLogger getLogger(String name, MessageFactory messageFactory) {
        ExtendedLogger extendedLogger = (ExtendedLogger)loggers.get(name);
        if (extendedLogger != null) {
            AbstractLogger.checkMessageFactory(extendedLogger, messageFactory);
            return extendedLogger;
        }
        loggers.putIfAbsent(name, new Log4jv2Logger(name, messageFactory, paxLogging));
        return (ExtendedLogger)loggers.get(name);
    }

    @Override
    public boolean hasLogger(String name) {
        return loggers.containsKey(name);
    }

    @Override
    public boolean hasLogger(String name, MessageFactory messageFactory) {
        return this.hasLogger(name);
    }

    @Override
    public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
        return this.hasLogger(name);
    }

    @Override
    public Object getExternalContext() {
        return null;
    }
}

