/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.errors;

import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.ErrorHandlerContext;
import org.apache.kafka.streams.errors.internals.ExceptionHandlerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAndFailExceptionHandler
implements DeserializationExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(LogAndFailExceptionHandler.class);
    private String deadLetterQueueTopic = null;

    @Override
    public DeserializationExceptionHandler.Response handleError(ErrorHandlerContext context, ConsumerRecord<byte[], byte[]> record, Exception exception) {
        log.error("Exception caught during Deserialization, taskId: {}, topic: {}, partition: {}, offset: {}", new Object[]{context.taskId(), record.topic(), record.partition(), record.offset(), exception});
        return DeserializationExceptionHandler.Response.fail(ExceptionHandlerUtils.maybeBuildDeadLetterQueueRecords(this.deadLetterQueueTopic, context.sourceRawKey(), context.sourceRawValue(), context, exception));
    }

    public void configure(Map<String, ?> configs) {
        if (configs.get("errors.dead.letter.queue.topic.name") != null) {
            this.deadLetterQueueTopic = String.valueOf(configs.get("errors.dead.letter.queue.topic.name"));
        }
    }
}

