/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams.topics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.StreamsGroupHeartbeatResponseData;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataImage;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.streams.StreamsGroup;
import org.apache.kafka.coordinator.group.streams.StreamsGroupMember;
import org.apache.kafka.coordinator.group.streams.topics.ConfiguredSubtopology;
import org.apache.kafka.coordinator.group.streams.topics.ConfiguredTopology;

public class EndpointToPartitionsManager {
    private EndpointToPartitionsManager() {
    }

    public static Optional<StreamsGroupHeartbeatResponseData.EndpointToPartitions> maybeEndpointToPartitions(StreamsGroupMember streamsGroupMember, StreamsGroup streamsGroup, CoordinatorMetadataImage metadataImage) {
        Optional<StreamsGroupMemberMetadataValue.Endpoint> endpointOptional = streamsGroupMember.userEndpoint();
        if (endpointOptional.isEmpty()) {
            return Optional.empty();
        }
        StreamsGroupMemberMetadataValue.Endpoint endpoint = endpointOptional.get();
        StreamsGroupHeartbeatResponseData.Endpoint responseEndpoint = new StreamsGroupHeartbeatResponseData.Endpoint();
        responseEndpoint.setHost(endpoint.host());
        responseEndpoint.setPort(endpoint.port());
        return Optional.of(EndpointToPartitionsManager.endpointToPartitions(streamsGroupMember, responseEndpoint, streamsGroup, metadataImage));
    }

    public static StreamsGroupHeartbeatResponseData.EndpointToPartitions endpointToPartitions(StreamsGroupMember streamsGroupMember, StreamsGroupHeartbeatResponseData.Endpoint responseEndpoint, StreamsGroup streamsGroup, CoordinatorMetadataImage metadataImage) {
        StreamsGroupHeartbeatResponseData.EndpointToPartitions endpointToPartitions = new StreamsGroupHeartbeatResponseData.EndpointToPartitions();
        Map<String, Set<Integer>> activeTasks = streamsGroupMember.assignedTasks().activeTasksWithEpochs().entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).keySet()));
        Map<String, Set<Integer>> standbyTasks = streamsGroupMember.assignedTasks().standbyTasks();
        endpointToPartitions.setUserEndpoint(responseEndpoint);
        Map configuredSubtopologies = (Map)streamsGroup.configuredTopology().flatMap(ConfiguredTopology::subtopologies).get();
        List<StreamsGroupHeartbeatResponseData.TopicPartition> activeTopicPartitions = EndpointToPartitionsManager.topicPartitions(activeTasks, configuredSubtopologies, metadataImage);
        List<StreamsGroupHeartbeatResponseData.TopicPartition> standbyTopicPartitions = EndpointToPartitionsManager.topicPartitions(standbyTasks, configuredSubtopologies, metadataImage);
        endpointToPartitions.setActivePartitions(activeTopicPartitions);
        endpointToPartitions.setStandbyPartitions(standbyTopicPartitions);
        return endpointToPartitions;
    }

    private static List<StreamsGroupHeartbeatResponseData.TopicPartition> topicPartitions(Map<String, Set<Integer>> tasks, Map<String, ConfiguredSubtopology> configuredSubtopologies, CoordinatorMetadataImage metadataImage) {
        ArrayList<StreamsGroupHeartbeatResponseData.TopicPartition> topicPartitionsForTasks = new ArrayList<StreamsGroupHeartbeatResponseData.TopicPartition>();
        for (Map.Entry<String, Set<Integer>> taskEntry : tasks.entrySet()) {
            String subtopologyId = taskEntry.getKey();
            ConfiguredSubtopology configuredSubtopology = configuredSubtopologies.get(subtopologyId);
            Set<String> sourceTopics = configuredSubtopology.sourceTopics();
            Set<String> repartitionSourceTopics = configuredSubtopology.repartitionSourceTopics().keySet();
            HashSet<String> allSourceTopic = new HashSet<String>(sourceTopics);
            allSourceTopic.addAll(repartitionSourceTopics);
            List<StreamsGroupHeartbeatResponseData.TopicPartition> topicPartitionList = EndpointToPartitionsManager.topicPartitionListForTask(taskEntry.getValue(), allSourceTopic, metadataImage);
            topicPartitionsForTasks.addAll(topicPartitionList);
        }
        return topicPartitionsForTasks;
    }

    private static List<StreamsGroupHeartbeatResponseData.TopicPartition> topicPartitionListForTask(Set<Integer> taskSet, Set<String> topicNames, CoordinatorMetadataImage metadataImage) {
        return topicNames.stream().map(topic -> {
            Optional topicMetadata = metadataImage.topicMetadata(topic);
            if (topicMetadata.isEmpty()) {
                throw new IllegalStateException("Topic " + topic + " not found in metadata image");
            }
            int numPartitionsForTopic = ((CoordinatorMetadataImage.TopicMetadata)topicMetadata.get()).partitionCount();
            StreamsGroupHeartbeatResponseData.TopicPartition tp = new StreamsGroupHeartbeatResponseData.TopicPartition();
            tp.setTopic(topic);
            ArrayList tpPartitions = new ArrayList(taskSet);
            if (numPartitionsForTopic < taskSet.size()) {
                Collections.sort(tpPartitions);
                tp.setPartitions(tpPartitions.subList(0, numPartitionsForTopic));
            } else {
                tp.setPartitions(tpPartitions);
            }
            return tp;
        }).toList();
    }
}

