/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.image.node.DelegationTokenImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.DelegationTokenData;

public record DelegationTokenImage(Map<String, DelegationTokenData> tokens) {
    public static final DelegationTokenImage EMPTY = new DelegationTokenImage(Map.of());

    public DelegationTokenImage(Map<String, DelegationTokenData> tokens) {
        this.tokens = Collections.unmodifiableMap(tokens);
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        if (options.metadataVersion().isDelegationTokenSupported()) {
            for (Map.Entry<String, DelegationTokenData> entry : this.tokens.entrySet()) {
                writer.write(0, entry.getValue().toRecord());
            }
        } else if (!this.tokens.isEmpty()) {
            ArrayList<String> tokenIds = new ArrayList<String>(this.tokens.keySet());
            String delegationTokenImageString = "DelegationTokenImage(" + String.join((CharSequence)", ", tokenIds) + ")";
            options.handleLoss(delegationTokenImageString);
        }
    }

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    @Override
    public String toString() {
        return new DelegationTokenImageNode(this).stringify();
    }
}

