/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.ConfigException;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class DynamicThreadPool$ {
    public static final DynamicThreadPool$ MODULE$ = new DynamicThreadPool$();
    private static final Set<String> ReconfigurableConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"num.io.threads", "num.replica.fetchers", "num.recovery.threads.per.data.dir", "background.threads"}));

    public Set<String> ReconfigurableConfigs() {
        return ReconfigurableConfigs;
    }

    public void validateReconfiguration(KafkaConfig currentConfig, KafkaConfig newConfig) {
        newConfig.values().forEach((k, v) -> {
            if (MODULE$.ReconfigurableConfigs().contains(k)) {
                int oldValue;
                int newValue = BoxesRunTime.unboxToInt((Object)v);
                if (newValue != (oldValue = MODULE$.getValue(currentConfig, (String)k))) {
                    String errorMsg = "Dynamic thread count update validation failed for " + k + "=" + v;
                    if (newValue <= 0) {
                        throw new ConfigException(errorMsg + ", value should be at least 1");
                    }
                    if (newValue < oldValue / 2) {
                        throw new ConfigException(errorMsg + ", value should be at least half the current value " + oldValue);
                    }
                    if (newValue > oldValue * 2) {
                        throw new ConfigException(errorMsg + ", value should not be greater than double the current value " + oldValue);
                    }
                    return;
                }
                return;
            }
        });
    }

    public int getValue(KafkaConfig config, String name) {
        switch (name == null ? 0 : name.hashCode()) {
            case -1436496784: {
                if (!"num.recovery.threads.per.data.dir".equals(name)) break;
                return Predef$.MODULE$.Integer2int(config.numRecoveryThreadsPerDataDir());
            }
            case -311660983: {
                if (!"num.io.threads".equals(name)) break;
                return Predef$.MODULE$.Integer2int(config.numIoThreads());
            }
            case 208778826: {
                if (!"num.replica.fetchers".equals(name)) break;
                return Predef$.MODULE$.Integer2int(config.numReplicaFetchers());
            }
            case 1349913321: {
                if (!"background.threads".equals(name)) break;
                return Predef$.MODULE$.Integer2int(config.backgroundThreads());
            }
        }
        throw new IllegalStateException("Unexpected config " + name);
    }

    private DynamicThreadPool$() {
    }
}

