/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.processor.api.ContextualFixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;

class KStreamMapValues<KIn, VIn, VOut>
implements FixedKeyProcessorSupplier<KIn, VIn, VOut> {
    private final ValueMapperWithKey<KIn, VIn, VOut> mapper;

    public KStreamMapValues(ValueMapperWithKey<KIn, VIn, VOut> mapper) {
        this.mapper = mapper;
    }

    @Override
    public FixedKeyProcessor<KIn, VIn, VOut> get() {
        return new KStreamMapProcessor();
    }

    private class KStreamMapProcessor
    extends ContextualFixedKeyProcessor<KIn, VIn, VOut> {
        private KStreamMapProcessor() {
        }

        @Override
        public void process(FixedKeyRecord<KIn, VIn> record) {
            Object newValue = KStreamMapValues.this.mapper.apply(record.key(), record.value());
            this.context().forward(record.withValue(newValue));
        }
    }
}

