/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.AssertionPredicate;
import org.apache.juneau.assertions.FluentAnyAssertion;
import org.apache.juneau.assertions.FluentAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;

public class FluentObjectAssertion<T, R>
extends FluentAssertion<R> {
    private static final Messages MESSAGES = Messages.of(FluentObjectAssertion.class, (String)"Messages");
    private static final String MSG_unexpectedType = MESSAGES.getString("unexpectedType");
    private static final String MSG_unexpectedComparison = MESSAGES.getString("unexpectedComparison");
    private static final String MSG_unexpectedValue = MESSAGES.getString("unexpectedValue");
    private static final String MSG_unexpectedValueDidNotExpect = MESSAGES.getString("unexpectedValueDidNotExpect");
    private static final String MSG_notTheSameValue = MESSAGES.getString("notTheSameValue");
    private static final String MSG_valueWasNull = MESSAGES.getString("valueWasNull");
    private static final String MSG_valueWasNotNull = MESSAGES.getString("valueWasNotNull");
    private static final String MSG_expectedValueNotFound = MESSAGES.getString("expectedValueNotFound");
    private static final String MSG_unexpectedValueFound = MESSAGES.getString("unexpectedValueFound");
    private static final String MSG_unexpectedValue2 = MESSAGES.getString("unexpectedValue2");
    private static final JsonSerializer JSON = JsonSerializer.create().json5().build();
    private static final JsonSerializer JSON_SORTED = JsonSerializer.create().json5().sortProperties().sortCollections().sortMaps().build();
    private final T value;

    public FluentObjectAssertion(Assertion creator, T value, R returns) {
        super(creator, returns);
        this.value = value;
    }

    public FluentObjectAssertion(T value, R returns) {
        this(null, value, returns);
    }

    public FluentAnyAssertion<T, R> asAny() {
        return new FluentAnyAssertion(this, this.orElse(null), this.returns());
    }

    public FluentStringAssertion<R> asJson() {
        return this.asString((WriterSerializer)JSON);
    }

    public FluentStringAssertion<R> asJsonSorted() {
        return this.asString((WriterSerializer)JSON_SORTED);
    }

    public FluentStringAssertion<R> asString() {
        return new FluentStringAssertion((Assertion)this, this.valueAsString(), this.returns());
    }

    public FluentStringAssertion<R> asString(Function<T, String> function) {
        return new FluentStringAssertion((Assertion)this, function.apply(this.value), this.returns());
    }

    public FluentStringAssertion<R> asString(WriterSerializer ws) {
        try {
            return new FluentStringAssertion((Assertion)this, ws.serialize(this.value), this.returns());
        }
        catch (SerializeException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    public FluentObjectAssertion<T, R> asTransformed(Function<T, T> function) {
        return new FluentObjectAssertion(this, function.apply(this.orElse(null)), this.returns());
    }

    public <T2> FluentObjectAssertion<T2, R> asTransformedTo(Function<T, T2> function) {
        return new FluentObjectAssertion(this, function.apply(this.orElse(null)), this.returns());
    }

    public R is(Predicate<T> test) throws AssertionError {
        if (Utils.nn(test) && !test.test(this.value)) {
            throw this.error(this.getFailureMessage(test, this.value), new Object[0]);
        }
        return this.returns();
    }

    public R is(T value) throws AssertionError {
        if (this.value == value) {
            return this.returns();
        }
        if (!this.equals(this.orElse(null), value)) {
            throw this.error(MSG_unexpectedValue, Utils.r(value), Utils.r(this.value));
        }
        return this.returns();
    }

    @SafeVarargs
    public final R isAny(T ... values) throws AssertionError {
        for (T v : values) {
            if (!this.equals(this.orElse(null), v)) continue;
            return this.returns();
        }
        throw this.error(MSG_expectedValueNotFound, Utils.r(values), Utils.r(this.value));
    }

    public R isExactType(Class<?> type) throws AssertionError {
        AssertionUtils.assertArgNotNull((String)"parent", type);
        if (this.value().getClass() != type) {
            throw this.error(MSG_unexpectedType, Utils.cn(type), Utils.cn(this.value));
        }
        return this.returns();
    }

    public R isExists() throws AssertionError {
        return this.isNotNull();
    }

    public R isJson(String value) {
        return this.asJson().is(value);
    }

    public R isNot(T value) throws AssertionError {
        if (this.equals(this.orElse(null), value)) {
            throw this.error(MSG_unexpectedValueDidNotExpect, Utils.r(value), Utils.r(this.orElse(null)));
        }
        return this.returns();
    }

    @SafeVarargs
    public final R isNotAny(T ... values) throws AssertionError {
        for (T v : values) {
            if (!this.equals(this.orElse(null), v)) continue;
            throw this.error(MSG_unexpectedValueFound, Utils.r(v), Utils.r(this.value));
        }
        return this.returns();
    }

    public R isNotNull() throws AssertionError {
        if (this.value == null) {
            throw this.error(MSG_valueWasNull, new Object[0]);
        }
        return this.returns();
    }

    public R isNull() throws AssertionError {
        if (Utils.nn(this.value)) {
            throw this.error(MSG_valueWasNotNull, new Object[0]);
        }
        return this.returns();
    }

    public R isSame(T value) throws AssertionError {
        if (this.value == value) {
            return this.returns();
        }
        throw this.error(MSG_notTheSameValue, Utils.r(value), Utils.id(value), Utils.r(this.value), Utils.id(this.value));
    }

    public R isSameJsonAs(Object o) throws AssertionError {
        return this.isSameSerializedAs(o, (WriterSerializer)JSON);
    }

    public R isSameSerializedAs(Object o, WriterSerializer serializer) {
        String s2;
        String s1 = serializer.toString(this.value);
        if (Utils.neq((Object)s1, (Object)(s2 = serializer.toString(o)))) {
            throw this.error(MSG_unexpectedComparison, s2, s1);
        }
        return this.returns();
    }

    public R isSameSortedJsonAs(Object o) {
        return this.isSameSerializedAs(o, (WriterSerializer)JSON_SORTED);
    }

    public R isString(String value) {
        return this.asString().is(value);
    }

    public R isType(Class<?> parent) throws AssertionError {
        AssertionUtils.assertArgNotNull((String)"parent", parent);
        if (!ReflectionUtils.info(this.value()).isChildOf(parent)) {
            throw this.error(MSG_unexpectedType, Utils.cn(parent), Utils.cn(this.value));
        }
        return this.returns();
    }

    @Override
    public FluentObjectAssertion<T, R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentObjectAssertion<T, R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentObjectAssertion<T, R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentObjectAssertion<T, R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentObjectAssertion<T, R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    public String toString() {
        return this.valueAsString();
    }

    protected boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (Utils.isArray((Object)o1)) {
            return StringUtils.readable((Object)o1).equals(StringUtils.readable((Object)o2));
        }
        return false;
    }

    protected String getFailureMessage(Predicate<?> p, Object value) {
        if (p instanceof AssertionPredicate) {
            AssertionPredicate p2 = (AssertionPredicate)p;
            return p2.getFailureMessage();
        }
        return Utils.f((String)MSG_unexpectedValue2, (Object[])new Object[]{Utils.r((Object)value)});
    }

    protected <T2> Optional<T2> map(Function<? super T, ? extends T2> mapper) {
        return this.opt().map(mapper);
    }

    protected Optional<T> opt() {
        return Utils.opt(this.value);
    }

    protected T orElse(T other) {
        return this.value == null ? other : this.value;
    }

    protected T value() throws AssertionError {
        this.isExists();
        return this.value;
    }

    protected String valueAsString() {
        return StringUtils.readable(this.value);
    }

    protected boolean valueIsNotNull() {
        return Utils.nn(this.value);
    }

    protected boolean valueIsNull() {
        return this.value == null;
    }
}

