/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.uon.ParamFormat;
import org.apache.juneau.uon.UonBeanPropertyMeta;
import org.apache.juneau.uon.UonClassMeta;
import org.apache.juneau.uon.UonMetaProvider;
import org.apache.juneau.uon.UonSerializerSession;

public class UonSerializer
extends WriterSerializer
implements HttpPartSerializer,
UonMetaProvider {
    public static final UonSerializer DEFAULT = new UonSerializer(UonSerializer.create());
    public static final UonSerializer DEFAULT_READABLE = new Readable(UonSerializer.create());
    public static final UonSerializer DEFAULT_ENCODING = new Encoding(UonSerializer.create());
    protected final boolean addBeanTypesUon;
    protected final boolean encoding;
    protected final Character quoteCharUon;
    protected final ParamFormat paramFormat;
    private final boolean addBeanTypes;
    private final char quoteChar;
    private final Map<BeanPropertyMeta, UonBeanPropertyMeta> uonBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, UonBeanPropertyMeta>();
    private final Map<ClassMeta<?>, UonClassMeta> uonClassMetas = new ConcurrentHashMap();

    public static Builder create() {
        return new Builder();
    }

    public UonSerializer(Builder builder) {
        super(builder);
        this.addBeanTypesUon = builder.addBeanTypesUon;
        this.encoding = builder.encoding;
        this.paramFormat = builder.paramFormat;
        this.quoteCharUon = builder.quoteCharUon;
        boolean bl = this.addBeanTypes = this.addBeanTypesUon || super.isAddBeanTypes();
        this.quoteChar = Utils.nn((Object)this.quoteCharUon) ? this.quoteCharUon.charValue() : (Utils.nn((Object)super.quoteChar()) ? (int)super.quoteChar().charValue() : 39);
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public UonSerializerSession.Builder createSession() {
        return UonSerializerSession.create(this);
    }

    @Override
    public UonSerializerSession getPartSession() {
        return UonSerializerSession.create(this).build();
    }

    @Override
    public UonSerializerSession getSession() {
        return this.createSession().build();
    }

    @Override
    public UonBeanPropertyMeta getUonBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return UonBeanPropertyMeta.DEFAULT;
        }
        UonBeanPropertyMeta m = this.uonBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new UonBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.uonBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public UonClassMeta getUonClassMeta(ClassMeta<?> cm) {
        UonClassMeta m = this.uonClassMetas.get(cm);
        if (m == null) {
            m = new UonClassMeta(cm, this);
            this.uonClassMetas.put(cm, m);
        }
        return m;
    }

    public String serialize(HttpPartType partType, HttpPartSchema schema, Object value) throws SchemaValidationException, SerializeException {
        return this.getPartSession().serialize(partType, schema, value);
    }

    protected final ParamFormat getParamFormat() {
        return this.paramFormat;
    }

    @Override
    protected final char getQuoteChar() {
        return this.quoteChar;
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final boolean isEncoding() {
        return this.encoding;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"addBeanTypes", (Object)this.addBeanTypes).a((Object)"encoding", (Object)this.encoding).a((Object)"paramFormat", (Object)this.paramFormat);
    }

    public static class Builder
    extends WriterSerializer.Builder {
        private static final Cache<HashKey, UonSerializer> CACHE = Cache.of(HashKey.class, UonSerializer.class).build();
        private boolean addBeanTypesUon;
        private boolean encoding;
        private ParamFormat paramFormat;
        private Character quoteCharUon;

        protected Builder() {
            this.produces("text/uon");
            this.addBeanTypesUon = (Boolean)Utils.env((String)"UonSerializer.addBeanTypesUon", (Object)false);
            this.encoding = (Boolean)Utils.env((String)"UonSerializer.encoding", (Object)false);
            this.paramFormat = (ParamFormat)((Object)Utils.env((String)"UonSerializer.paramFormat", (Object)((Object)ParamFormat.UON)));
            this.quoteCharUon = null;
        }

        protected Builder(Builder copyFrom) {
            super((WriterSerializer.Builder)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom));
            this.addBeanTypesUon = copyFrom.addBeanTypesUon;
            this.encoding = copyFrom.encoding;
            this.paramFormat = copyFrom.paramFormat;
            this.quoteCharUon = copyFrom.quoteCharUon;
        }

        protected Builder(UonSerializer copyFrom) {
            super((WriterSerializer)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom));
            this.addBeanTypesUon = copyFrom.addBeanTypesUon;
            this.encoding = copyFrom.encoding;
            this.paramFormat = copyFrom.paramFormat;
            this.quoteCharUon = copyFrom.quoteCharUon;
        }

        @Override
        public Builder accept(String value) {
            super.accept(value);
            return this;
        }

        @Override
        public Builder addBeanTypes() {
            super.addBeanTypes();
            return this;
        }

        @Override
        public Builder addBeanTypes(boolean value) {
            super.addBeanTypes(value);
            return this;
        }

        public Builder addBeanTypesUon() {
            return this.addBeanTypesUon(true);
        }

        public Builder addBeanTypesUon(boolean value) {
            this.addBeanTypesUon = value;
            return this;
        }

        @Override
        public Builder addRootType() {
            super.addRootType();
            return this;
        }

        @Override
        public Builder addRootType(boolean value) {
            super.addRootType(value);
            return this;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties((Map)values);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public UonSerializer build() {
            return this.cache((Cache)CACHE).build(UonSerializer.class);
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder detectRecursions() {
            super.detectRecursions();
            return this;
        }

        @Override
        public Builder detectRecursions(boolean value) {
            super.detectRecursions(value);
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn((Class)on, (Class[])values);
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        public Builder encoding() {
            return this.encoding(true);
        }

        public Builder encoding(boolean value) {
            this.encoding = value;
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example((Class)pojoClass, json);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example((Class)pojoClass, (Object)o);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters((Class)on);
            return this;
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of((Object[])new Object[]{super.hashKey(), this.addBeanTypesUon, this.encoding, this.paramFormat, this.quoteCharUon});
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @Override
        public Builder ignoreRecursions() {
            super.ignoreRecursions();
            return this;
        }

        @Override
        public Builder ignoreRecursions(boolean value) {
            super.ignoreRecursions(value);
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass((Class)interfaceClass, (Class)implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses((Map)values);
            return this;
        }

        @Override
        public Builder initialDepth(int value) {
            super.initialDepth(value);
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        @Override
        public Builder keepNullProperties() {
            super.keepNullProperties();
            return this;
        }

        @Override
        public Builder keepNullProperties(boolean value) {
            super.keepNullProperties(value);
            return this;
        }

        @Override
        public Builder listener(Class<? extends SerializerListener> value) {
            super.listener((Class)value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder maxDepth(int value) {
            super.maxDepth(value);
            return this;
        }

        @Override
        public Builder maxIndent(int value) {
            super.maxIndent(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        public Builder paramFormat(ParamFormat value) {
            this.paramFormat = (ParamFormat)((Object)AssertionUtils.assertArgNotNull((String)"value", (Object)((Object)value)));
            return this;
        }

        public Builder paramFormatPlain() {
            return this.paramFormat(ParamFormat.PLAINTEXT);
        }

        @Override
        public Builder produces(String value) {
            super.produces(value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)value);
            return this;
        }

        @Override
        public Builder quoteChar(char value) {
            super.quoteChar(value);
            return this;
        }

        @Override
        public Builder quoteCharOverride(char value) {
            super.quoteCharOverride(value);
            return this;
        }

        public Builder quoteCharUon(char value) {
            this.quoteCharUon = Character.valueOf(value);
            return this;
        }

        @Override
        public Builder sortCollections() {
            super.sortCollections();
            return this;
        }

        @Override
        public Builder sortCollections(boolean value) {
            super.sortCollections(value);
            return this;
        }

        @Override
        public Builder sortMaps() {
            super.sortMaps();
            return this;
        }

        @Override
        public Builder sortMaps(boolean value) {
            super.sortMaps(value);
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        @Override
        public Builder sq() {
            super.sq();
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction, (ThrowingFunction)unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        @Override
        public Builder swaps(Object ... values) {
            super.swaps(values);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder trimEmptyCollections() {
            super.trimEmptyCollections();
            return this;
        }

        @Override
        public Builder trimEmptyCollections(boolean value) {
            super.trimEmptyCollections(value);
            return this;
        }

        @Override
        public Builder trimEmptyMaps() {
            super.trimEmptyMaps();
            return this;
        }

        @Override
        public Builder trimEmptyMaps(boolean value) {
            super.trimEmptyMaps(value);
            return this;
        }

        @Override
        public Builder trimStrings() {
            super.trimStrings();
            return this;
        }

        @Override
        public Builder trimStrings(boolean value) {
            super.trimStrings(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder uriRelativity(UriRelativity value) {
            super.uriRelativity(value);
            return this;
        }

        @Override
        public Builder uriResolution(UriResolution value) {
            super.uriResolution(value);
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        @Override
        public Builder useWhitespace() {
            super.useWhitespace();
            return this;
        }

        @Override
        public Builder useWhitespace(boolean value) {
            super.useWhitespace(value);
            return this;
        }

        @Override
        public Builder ws() {
            super.ws();
            return this;
        }
    }

    public static class Readable
    extends UonSerializer {
        public Readable(Builder builder) {
            super(builder.useWhitespace());
        }
    }

    public static class Encoding
    extends UonSerializer {
        public Encoding(Builder builder) {
            super(builder.encoding());
        }
    }
}

