/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Marshalled;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.annotation.AppliedOnClassAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.svl.VarResolverSession;

public class MarshalledAnnotation {
    public static final Marshalled DEFAULT = MarshalledAnnotation.create().build();

    public static Marshalled copy(Marshalled a, VarResolverSession r) {
        return MarshalledAnnotation.create().example(r.resolve(a.example())).implClass(a.implClass()).on(r.resolve(a.on())).onClass((Class[])a.onClass()).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return MarshalledAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return MarshalledAnnotation.create().on(on);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderT {
        private String[] description = new String[0];
        private Class<?> implClass = Void.TYPE;
        private String example = "";

        protected Builder() {
            super(Marshalled.class);
        }

        public Marshalled build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder example(String value) {
            this.example = value;
            return this;
        }

        public Builder implClass(Class<?> value) {
            this.implClass = value;
            return this;
        }

        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        public Builder on(ClassInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder onClass(ClassInfo ... value) {
            super.onClass(value);
            return this;
        }
    }

    private static class Object
    extends AppliedOnClassAnnotationObject
    implements Marshalled {
        private final String[] description;
        private final Class<?> implClass;
        private final String example;

        Object(Builder b) {
            super((AppliedAnnotationObject.BuilderT)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.example = b.example;
            this.implClass = b.implClass;
        }

        @Override
        public String example() {
            return this.example;
        }

        @Override
        public Class<?> implClass() {
            return this.implClass;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Marshalled[] value();
    }

    public static class Applier
    extends AnnotationApplier<Marshalled, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Marshalled.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Marshalled> ai, BeanContext.Builder b) {
            Marshalled a = (Marshalled)ai.inner();
            if (CollectionUtils.isEmptyArray((java.lang.Object[])a.on()) && CollectionUtils.isEmptyArray((java.lang.Object[])a.onClass())) {
                return;
            }
            b.annotations(MarshalledAnnotation.copy(a, this.vr()));
        }
    }
}

