/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.List;
import java.util.function.Consumer;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.juneau.MediaType;
import org.apache.juneau.commons.utils.CollectionUtils;

public class MediaRange
extends MediaType {
    private final NameValuePair[] extensions;
    private final Float qValue;
    private final String string;

    public MediaRange(HeaderElement e) {
        super(e);
        Float qValue = Float.valueOf(1.0f);
        List<NameValuePair> extensions = CollectionUtils.list(new NameValuePair[0]);
        boolean foundQ = false;
        for (NameValuePair p : e.getParameters()) {
            if (p.getName().equals("q")) {
                qValue = Float.valueOf(Float.parseFloat(p.getValue()));
                foundQ = true;
                continue;
            }
            if (!foundQ) continue;
            extensions.add((NameValuePair)new BasicNameValuePair(p.getName(), p.getValue()));
        }
        this.qValue = qValue;
        this.extensions = extensions.toArray(new NameValuePair[extensions.size()]);
        StringBuffer sb = new StringBuffer().append(super.toString());
        if ((double)qValue.floatValue() == 1.0) {
            if (this.extensions.length > 0) {
                sb.append(";q=").append(qValue);
                extensions.forEach(x -> sb.append(';').append(x.getName()).append('=').append(x.getValue()));
            }
        } else {
            sb.append(";q=").append(qValue);
            extensions.forEach(x -> sb.append(';').append(x.getName()).append('=').append(x.getValue()));
        }
        this.string = sb.toString();
    }

    public MediaRange forEachExtension(Consumer<NameValuePair> action) {
        for (NameValuePair r : this.extensions) {
            action.accept(r);
        }
        return this;
    }

    @Override
    public MediaRange forEachParameter(Consumer<NameValuePair> action) {
        super.forEachParameter(action);
        return this;
    }

    public List<NameValuePair> getExtensions() {
        return CollectionUtils.u(CollectionUtils.l(this.extensions));
    }

    public Float getQValue() {
        return this.qValue;
    }

    @Override
    public String toString() {
        return this.string;
    }
}

