/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.junit.bct;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.junit.bct.BeanConverter;
import org.apache.juneau.junit.bct.PropertyExtractor;
import org.apache.juneau.junit.bct.PropertyNotFoundException;

public class PropertyExtractors {
    private PropertyExtractors() {
    }

    public static class ObjectPropertyExtractor
    implements PropertyExtractor {
        @Override
        public boolean canExtract(BeanConverter converter, Object o, String name) {
            return true;
        }

        @Override
        public Object extract(BeanConverter converter, Object o, String name) {
            return Utils.safe(() -> {
                if (o == null) {
                    return null;
                }
                Field f = null;
                Class<?> c = o.getClass();
                String n = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                Method m = Arrays.stream(c.getMethods()).filter(x -> x.getName().equals("is" + n) && x.getParameterCount() == 0).findFirst().orElse(null);
                if (Utils.nn((Object)m)) {
                    m.setAccessible(true);
                    return m.invoke(o, new Object[0]);
                }
                if (o instanceof Map.Entry) {
                    Map.Entry me = (Map.Entry)o;
                    if ("key".equals(name)) {
                        return me.getKey();
                    }
                    if ("value".equals(name)) {
                        return me.getValue();
                    }
                }
                if (Utils.nn((Object)(m = (Method)Arrays.stream(c.getMethods()).filter(x -> x.getName().equals("get" + n) && x.getParameterCount() == 0).findFirst().orElse(null)))) {
                    m.setAccessible(true);
                    return m.invoke(o, new Object[0]);
                }
                m = Arrays.stream(c.getMethods()).filter(x -> x.getName().equals("get") && x.getParameterCount() == 1 && x.getParameterTypes()[0] == String.class).findFirst().orElse(null);
                if (Utils.nn((Object)m)) {
                    m.setAccessible(true);
                    return m.invoke(o, name);
                }
                Class<?> c2 = c;
                while (f == null && Utils.nn(c2)) {
                    f = Arrays.stream(c2.getDeclaredFields()).filter(x -> x.getName().equals(name)).findFirst().orElse(null);
                    c2 = c2.getSuperclass();
                }
                if (Utils.nn((Object)f)) {
                    f.setAccessible(true);
                    return f.get(o);
                }
                m = Arrays.stream(c.getMethods()).filter(x -> x.getName().equals(name) && x.getParameterCount() == 0).findFirst().orElse(null);
                if (Utils.nn((Object)m)) {
                    m.setAccessible(true);
                    return m.invoke(o, new Object[0]);
                }
                throw new PropertyNotFoundException(name, o.getClass());
            });
        }
    }

    public static class MapPropertyExtractor
    extends ObjectPropertyExtractor {
        @Override
        public boolean canExtract(BeanConverter converter, Object o, String name) {
            return o instanceof Map;
        }

        @Override
        public Object extract(BeanConverter converter, Object o, String name) {
            Map m = (Map)o;
            if (Utils.eq((Object)name, (Object)converter.getSetting("nullValue", "<null>"))) {
                name = null;
            }
            if (m.containsKey(name)) {
                return m.get(name);
            }
            if ("size".equals(name)) {
                return m.size();
            }
            return super.extract(converter, o, name);
        }
    }

    public static class ListPropertyExtractor
    extends ObjectPropertyExtractor {
        @Override
        public boolean canExtract(BeanConverter converter, Object o, String name) {
            return converter.canListify(o);
        }

        @Override
        public Object extract(BeanConverter converter, Object o, String name) {
            List<Object> l = converter.listify(o);
            if (name.matches("-?\\d+")) {
                int index = StringUtils.parseInt((String)name);
                if (index < 0) {
                    index = l.size() + index;
                }
                return l.get(index);
            }
            if ("length".equals(name)) {
                return l.size();
            }
            if ("size".equals(name)) {
                return l.size();
            }
            return super.extract(converter, o, name);
        }
    }
}

