/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class ClassUtils {
    public static final Predicate<Class<?>> NOT_VOID = ClassUtils::isNotVoid;
    private static Cache<Class, Boolean> MODIFIABLE_COLLECTION_TYPES = Cache.of(Class.class, Boolean.class).build();

    public static boolean canAddTo(Collection<?> value) {
        AssertionUtils.assertArgNotNull("value", value);
        return ClassUtils.canAddTo(value.getClass());
    }

    public static boolean canPutTo(Map<?, ?> value) {
        AssertionUtils.assertArgNotNull("value", value);
        return ClassUtils.canAddTo(value.getClass());
    }

    public static String className(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Class) {
            Class value2 = (Class)value;
            return value2.getName();
        }
        if (value instanceof ClassInfo) {
            ClassInfo value2 = (ClassInfo)value;
            return value2.getName();
        }
        return value.getClass().getName();
    }

    public static String classNameSimple(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Class) {
            Class value2 = (Class)value;
            return value2.getSimpleName();
        }
        if (value instanceof ClassInfo) {
            ClassInfo value2 = (ClassInfo)value;
            return value2.getNameSimple();
        }
        return value.getClass().getSimpleName();
    }

    public static String classNameSimpleQualified(Object value) {
        Class<?> clazz;
        if (value == null) {
            return null;
        }
        Class<?> clazz2 = clazz = value instanceof Class ? (Class<?>)value : value.getClass();
        if (clazz.isArray()) {
            return ClassUtils.classNameSimpleQualified(clazz.getComponentType()) + "[]";
        }
        String className = clazz.getName();
        int lastDot = className.lastIndexOf(46);
        String simpleName = lastDot == -1 ? className : className.substring(lastDot + 1);
        return simpleName.replace('$', '.');
    }

    public static Class<?>[] getClasses(Object ... args) {
        Class[] pt = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            pt[i] = args[i] == null ? null : args[i].getClass();
        }
        return pt;
    }

    public static Object[] getMatchingArgs(Class<?>[] paramTypes, Object ... args) {
        boolean needsShuffle;
        AssertionUtils.assertArgNotNull("args", args);
        boolean bl = needsShuffle = paramTypes.length != args.length;
        if (!needsShuffle) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i].isInstance(args[i])) continue;
                needsShuffle = true;
            }
        }
        if (!needsShuffle) {
            return args;
        }
        Object[] params = new Object[paramTypes.length];
        block1: for (int i = 0; i < paramTypes.length; ++i) {
            ClassInfo pt = ReflectionUtils.info(paramTypes[i]).getWrapperIfPrimitive();
            for (Object arg : args) {
                if (!Utils.nn(arg) || !pt.isParentOf(arg.getClass())) continue;
                params[i] = arg;
                continue block1;
            }
        }
        return params;
    }

    public static Class<?> getProxyFor(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        String s = c.getName();
        if (s.indexOf(36) == -1) {
            return null;
        }
        if (Proxy.isProxyClass(c)) {
            Class<?>[] interfaces = c.getInterfaces();
            return interfaces.length > 0 ? interfaces[0] : null;
        }
        if (s.contains("$$EnhancerBySpringCGLIB$$")) {
            Value v = Value.empty();
            ReflectionUtils.info(c).getPublicMethods().stream().filter(m -> m.hasName("getTargetClass") && m.getParameterCount() == 0 && m.hasReturnType(Class.class)).forEach(m -> Utils.safe(() -> v.set((Class)m.invoke(o, new Object[0]))));
            return v.isPresent() ? (Class)v.get() : c.getSuperclass();
        }
        if (s.contains("_$$_javassist") || s.contains("_$$_jvst") || s.contains("$ByteBuddy$")) {
            return c.getSuperclass();
        }
        return null;
    }

    public static boolean isNotVoid(Class c) {
        return !ClassUtils.isVoid(c);
    }

    public static boolean isVoid(Class c) {
        return c == null || c == Void.TYPE || c == Void.class || Utils.cns(c).equalsIgnoreCase("void");
    }

    public static boolean setAccessible(Constructor<?> x) {
        AssertionUtils.assertArgNotNull("x", x);
        return Utils.safeOpt(() -> {
            x.setAccessible(true);
            return true;
        }).orElse(false);
    }

    public static boolean setAccessible(Field x) {
        AssertionUtils.assertArgNotNull("x", x);
        return Utils.safeOpt(() -> {
            x.setAccessible(true);
            return true;
        }).orElse(false);
    }

    public static boolean setAccessible(Method x) {
        AssertionUtils.assertArgNotNull("x", x);
        return Utils.safeOpt(() -> {
            x.setAccessible(true);
            return true;
        }).orElse(false);
    }

    public static Class<?> toClass(Type t) {
        if (t instanceof Class) {
            Class c = (Class)t;
            return c;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType t2 = (ParameterizedType)t;
            return (Class)t2.getRawType();
        }
        return null;
    }

    private static boolean canAddTo(Class<?> c) {
        Boolean b = MODIFIABLE_COLLECTION_TYPES.get(c);
        if (b == null) {
            String name = c.getName();
            b = !name.contains("Immutable") && !name.contains("Unmodifiable") && !name.contains("Arrays$ArrayList");
            MODIFIABLE_COLLECTION_TYPES.put(c, b);
        }
        return b;
    }
}

