/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.remote;

import java.lang.reflect.Method;
import org.apache.juneau.commons.reflect.ClassArrayFormat;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ClassNameFormat;
import org.apache.juneau.commons.utils.StringUtils;

public class RrpcInterfaceMethodMeta {
    private final String url;
    private final String path;
    private final Method method;

    private static String getMethodArgsSignature(Method m) {
        StringBuilder sb = new StringBuilder(128);
        Class<?>[] pt = m.getParameterTypes();
        if (pt.length == 0) {
            return "";
        }
        sb.append('(');
        for (int i = 0; i < pt.length; ++i) {
            ClassInfoTyped pti = ClassInfo.of(pt[i]);
            if (i > 0) {
                sb.append(',');
            }
            pti.appendNameFormatted(sb, ClassNameFormat.FULL, true, '$', ClassArrayFormat.BRACKETS);
        }
        sb.append(')');
        return sb.toString();
    }

    public RrpcInterfaceMethodMeta(String restUrl, Method m) {
        this.method = m;
        this.path = m.getName() + "/" + RrpcInterfaceMethodMeta.getMethodArgsSignature(m);
        this.url = StringUtils.trimSlashes((String)restUrl) + "/" + StringUtils.urlEncode((String)this.path);
    }

    public Method getJavaMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getUri() {
        return this.url;
    }
}

