/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import org.apache.juneau.commons.collections.SimpleMap;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;

public class ResultSetList
extends LinkedList<Map<String, Object>> {
    private static final long serialVersionUID = 1L;

    static Object readEntry(ResultSet rs, int col, int dataType) {
        try {
            return switch (dataType) {
                case 2004 -> {
                    Blob b = rs.getBlob(col);
                    yield "blob[" + b.length() + "]";
                }
                case 2005 -> {
                    Clob c = rs.getClob(col);
                    yield "clob[" + c.length() + "]";
                }
                case -4 -> "longvarbinary[" + IoUtils.count((InputStream)rs.getBinaryStream(col)) + "]";
                case -1 -> "longvarchar[" + IoUtils.count((InputStream)rs.getAsciiStream(col)) + "]";
                case -16 -> "longnvarchar[" + IoUtils.count((Reader)rs.getCharacterStream(col)) + "]";
                case 93 -> rs.getTimestamp(col);
                default -> rs.getObject(col);
            };
        }
        catch (Exception e) {
            return ThrowableUtils.lm((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetList(ResultSet rs, int pos, int limit, boolean includeRowNums) throws SQLException {
        try {
            int rowNum = pos;
            ResultSetMetaData rsmd = rs.getMetaData();
            int offset = includeRowNums ? 1 : 0;
            int cc = rsmd.getColumnCount();
            Object[] columns = new String[cc + offset];
            if (includeRowNums) {
                columns[0] = "ROW";
            }
            int[] colTypes = new int[cc];
            for (int i = 0; i < cc; ++i) {
                columns[i + offset] = rsmd.getColumnName(i + 1);
                colTypes[i] = rsmd.getColumnType(i + 1);
            }
            while (--pos > 0 && rs.next()) {
            }
            while (limit-- > 0 && rs.next()) {
                Object[] row = new Object[cc + offset];
                if (includeRowNums) {
                    row[0] = rowNum++;
                }
                for (int i = 0; i < cc; ++i) {
                    Object o;
                    row[i + offset] = o = ResultSetList.readEntry(rs, i + 1, colTypes[i]);
                }
                this.add(new SimpleMap(columns, row));
            }
        }
        finally {
            rs.close();
        }
    }
}

