/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.NoSuchElementException;
import org.apache.http.NameValuePair;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.part.PartIterator;

public class BasicPartIterator
implements PartIterator {
    private final NameValuePair[] entries;
    private final String name;
    private final boolean caseInsensitive;
    private int currentIndex;

    public BasicPartIterator(NameValuePair[] parts, String name, boolean caseInsensitive) {
        this.entries = AssertionUtils.assertArgNotNull("parts", parts);
        this.name = name;
        this.caseInsensitive = caseInsensitive;
        this.currentIndex = this.findNext(-1);
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex >= 0;
    }

    @Override
    public NameValuePair next() throws NoSuchElementException {
        int current = this.currentIndex;
        if (current < 0) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        this.currentIndex = this.findNext(current);
        return this.entries[current];
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw ThrowableUtils.unsupportedOp();
    }

    private boolean eq(String s1, String s2) {
        return Utils.eq(this.caseInsensitive, s1, s2);
    }

    private boolean filter(int index) {
        return this.name == null || this.eq(this.name, this.entries[index].getName());
    }

    private int findNext(int pos) {
        int from = pos;
        int to = this.entries.length - 1;
        boolean found = false;
        while (!found && from < to) {
            found = this.filter(++from);
        }
        return found ? from : -1;
    }
}

