/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.io;

import java.io.IOException;
import java.io.Writer;
import org.apache.juneau.commons.utils.AssertionUtils;

public class StringBuilderWriter
extends Writer {
    private StringBuilder sb;

    public StringBuilderWriter() {
        this.sb = new StringBuilder();
        this.lock = null;
    }

    public StringBuilderWriter(int initialSize) {
        AssertionUtils.assertArg(initialSize >= 0, "Argument 'initialSize' cannot be negative.", new Object[0]);
        this.sb = new StringBuilder(initialSize);
        this.lock = null;
    }

    public StringBuilderWriter(StringBuilder sb) {
        this.sb = AssertionUtils.assertArgNotNull("sb", sb);
        this.lock = null;
    }

    @Override
    public StringBuilderWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public StringBuilderWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public StringBuilderWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() {
    }

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void write(char[] cbuf, int start, int length) {
        AssertionUtils.assertArgNotNull("cbuf", cbuf);
        this.sb.append(cbuf, start, length);
    }

    @Override
    public void write(int c) {
        this.sb.appendCodePoint(c);
    }

    @Override
    public void write(String str) {
        AssertionUtils.assertArgNotNull("str", str);
        this.sb.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        AssertionUtils.assertArgNotNull("str", str);
        this.sb.append(str.substring(off, off + len));
    }
}

