/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.function;

import java.util.function.Function;
import org.apache.juneau.commons.function.Function2;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;

@FunctionalInterface
public interface ThrowingFunction2<A, B, R>
extends Function2<A, B, R> {
    @Override
    default public R apply(A a, B b) {
        try {
            return this.applyThrows(a, b);
        }
        catch (Exception e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    @Override
    default public <V> ThrowingFunction2<A, B, V> andThen(Function<? super R, ? extends V> after) {
        AssertionUtils.assertArgNotNull("after", after);
        return (a, b) -> after.apply((R)this.applyThrows(a, b));
    }

    public R applyThrows(A var1, B var2) throws Exception;
}

