/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.atom;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.bean.atom.Category;
import org.apache.juneau.bean.atom.CommonEntry;
import org.apache.juneau.bean.atom.Content;
import org.apache.juneau.bean.atom.Id;
import org.apache.juneau.bean.atom.Link;
import org.apache.juneau.bean.atom.Person;
import org.apache.juneau.bean.atom.Source;
import org.apache.juneau.bean.atom.Text;
import org.apache.juneau.commons.time.GranularZonedDateTime;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;

@Bean(typeName="entry")
public class Entry
extends CommonEntry {
    private Content content;
    private Calendar published;
    private Source source;
    private Text summary;

    public Entry() {
    }

    public Entry(Id id, Text title, Calendar updated) {
        super(id, title, updated);
    }

    public Entry(String id, String title, String updated) {
        super(id, title, updated);
    }

    public Content getContent() {
        return this.content;
    }

    public Calendar getPublished() {
        return this.published;
    }

    public Source getSource() {
        return this.source;
    }

    public Text getSummary() {
        return this.summary;
    }

    @Override
    public Entry setAuthors(Person ... value) {
        super.setAuthors(value);
        return this;
    }

    @Override
    public Entry setBase(Object value) {
        super.setBase(value);
        return this;
    }

    @Override
    public Entry setCategories(Category ... value) {
        super.setCategories(value);
        return this;
    }

    public Entry setContent(Content value) {
        this.content = value;
        return this;
    }

    @Override
    public Entry setContributors(Person ... value) {
        super.setContributors(value);
        return this;
    }

    @Override
    public Entry setId(Id value) {
        super.setId(value);
        return this;
    }

    @Override
    public Entry setId(String value) {
        super.setId(value);
        return this;
    }

    @Override
    public Entry setLang(String value) {
        super.setLang(value);
        return this;
    }

    @Override
    public Entry setLinks(Link ... value) {
        super.setLinks(value);
        return this;
    }

    public Entry setPublished(Calendar value) {
        this.published = value;
        return this;
    }

    public Entry setPublished(String value) {
        this.setPublished((Calendar)Utils.opt(value).filter(x1 -> !StringUtils.isBlank(x1)).map(x -> GranularZonedDateTime.of(value).getZonedDateTime()).map(GregorianCalendar::from).orElse(null));
        return this;
    }

    @Override
    public Entry setRights(String value) {
        super.setRights(value);
        return this;
    }

    @Override
    public Entry setRights(Text value) {
        super.setRights(value);
        return this;
    }

    public Entry setSource(Source value) {
        this.source = value;
        return this;
    }

    public Entry setSummary(String value) {
        this.setSummary(new Text(value));
        return this;
    }

    public Entry setSummary(Text value) {
        this.summary = value;
        return this;
    }

    @Override
    public Entry setTitle(String value) {
        super.setTitle(value);
        return this;
    }

    @Override
    public Entry setTitle(Text value) {
        super.setTitle(value);
        return this;
    }

    @Override
    public Entry setUpdated(Calendar value) {
        super.setUpdated(value);
        return this;
    }

    @Override
    public Entry setUpdated(String value) {
        super.setUpdated(value);
        return this;
    }
}

