/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyConsumer;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.reflect.BeanRuntimeException;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.FilteredKeyMap;
import org.apache.juneau.json.Json5Serializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ReaderParser;

public class BeanMap<T>
extends AbstractMap<String, Object>
implements Delegate<T> {
    protected T bean;
    protected Map<String, Object> propertyCache;
    protected Map<String, List<?>> arrayPropertyCache;
    protected BeanMeta<T> meta;
    private final BeanSession session;
    private final String typePropertyName;

    public static <T> BeanMap<T> of(T bean) {
        return BeanContext.DEFAULT_SESSION.toBeanMap(bean);
    }

    protected BeanMap(BeanSession session, T bean, BeanMeta<T> meta) {
        this.session = session;
        this.bean = bean;
        this.meta = meta;
        if (Utils.ne(meta.getConstructorArgs())) {
            this.propertyCache = new TreeMap<String, Object>();
        }
        this.typePropertyName = session.getBeanTypePropertyName(meta.getClassMeta());
    }

    public void add(String property, Object value) {
        BeanPropertyMeta p = this.getPropertyMeta(property);
        if (p == null) {
            if (this.meta.getBeanContext().isIgnoreUnknownBeanProperties()) {
                return;
            }
            throw ThrowableUtils.bex(this.meta.getClassMeta(), "Bean property ''{0}'' not found.", property);
        }
        p.add(this, property, value);
    }

    @Override
    public boolean containsKey(Object property) {
        String key = Utils.emptyIfNull(property);
        if (this.meta.getProperties().containsKey(key) && !"*".equals(key)) {
            return true;
        }
        if (Utils.nn(this.meta.getDynaProperty())) {
            try {
                return this.meta.getDynaProperty().getDynaMap(this.bean).containsKey(key);
            }
            catch (Exception e) {
                throw ThrowableUtils.bex(e);
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (Utils.nn(this.meta.getDynaProperty())) {
            LinkedHashSet<Map.Entry<String, Object>> s = CollectionUtils.set(new Map.Entry[0]);
            this.forEachProperty(x -> true, x -> {
                if (x.isDyna()) {
                    try {
                        x.getDynaMap(this.bean).entrySet().forEach((? super T y) -> s.add(new BeanMapEntry(this, (BeanPropertyMeta)x, (String)y.getKey())));
                    }
                    catch (Exception e) {
                        throw ThrowableUtils.bex(e);
                    }
                } else {
                    s.add(new BeanMapEntry(this, (BeanPropertyMeta)x, x.getName()));
                }
            });
            return s;
        }
        AbstractSet<Map.Entry<String, Object>> s = new AbstractSet<Map.Entry<String, Object>>(){
            final Collection<BeanPropertyMeta> pSet;
            {
                this.pSet = BeanMap.this.getProperties();
            }

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    final Iterator<BeanPropertyMeta> pIterator;
                    {
                        this.pIterator = pSet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.pIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        return new BeanMapEntry(BeanMap.this, this.pIterator.next(), null);
                    }

                    @Override
                    public void remove() {
                        throw ThrowableUtils.unsupportedOp("Cannot remove item from iterator.", new Object[0]);
                    }
                };
            }

            @Override
            public int size() {
                return this.pSet.size();
            }
        };
        return s;
    }

    public BeanMap<T> forEachProperty(Predicate<BeanPropertyMeta> filter, Consumer<BeanPropertyMeta> action) {
        this.meta.getProperties().values().stream().filter(filter).forEach(action);
        return this;
    }

    public BeanMap<T> forEachValue(Predicate<Object> valueFilter, BeanPropertyConsumer action) {
        if (this.meta.getDynaProperty() == null) {
            this.forEachProperty(BeanPropertyMeta::canRead, bpm -> {
                try {
                    Object val = bpm.get(this, null);
                    if (valueFilter.test(val)) {
                        action.apply(bpm, bpm.getName(), val, null);
                    }
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable t) {
                    action.apply(bpm, bpm.getName(), null, t);
                }
            });
        } else {
            AbstractMap actions = this.meta.isSortProperties() ? CollectionUtils.sortedMap() : CollectionUtils.map();
            this.forEachProperty(x -> !x.isDyna(), bpm -> {
                try {
                    actions.put(bpm.getName(), new BeanPropertyValue((BeanPropertyMeta)bpm, bpm.getName(), bpm.get(this, null), null));
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable t) {
                    actions.put(bpm.getName(), new BeanPropertyValue((BeanPropertyMeta)bpm, bpm.getName(), null, t));
                }
            });
            this.forEachProperty(BeanPropertyMeta::isDyna, bpm -> {
                try {
                    Map<String, Object> dynaMap = bpm.getDynaMap(this.bean);
                    if (Utils.nn(dynaMap)) {
                        dynaMap.forEach((k, v) -> {
                            Object val = bpm.get(this, (String)k);
                            actions.put(k, new BeanPropertyValue((BeanPropertyMeta)bpm, (String)k, val, null));
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            actions.forEach((k, v) -> {
                if (valueFilter.test(v.getValue())) {
                    action.apply(v.getMeta(), v.getName(), v.getValue(), v.getThrown());
                }
            });
        }
        return this;
    }

    @Override
    public Object get(Object property) {
        String pName = Utils.s(property);
        BeanPropertyMeta p = this.getPropertyMeta(pName);
        if (p == null) {
            return this.meta.onReadProperty(this.bean, pName, null);
        }
        return p.get(this, pName);
    }

    public <T2> T2 get(String property, Class<T2> c) {
        String pName = Utils.s(property);
        BeanPropertyMeta p = this.getPropertyMeta(pName);
        if (p == null) {
            return (T2)this.meta.onReadProperty(this.bean, pName, null);
        }
        return (T2)p.get(this, pName);
    }

    public T getBean() {
        T b = this.getBean(true);
        if (Utils.nn(this.arrayPropertyCache)) {
            this.arrayPropertyCache.forEach((k, v) -> {
                try {
                    this.getPropertyMeta((String)k).setArray(b, (List)v);
                }
                catch (Exception e1) {
                    throw ThrowableUtils.toRex(e1);
                }
            });
            this.arrayPropertyCache = null;
        }
        this.meta.getProperties().forEach((k, v) -> {
            ClassMeta<?> cm = v.getClassMeta();
            if (cm.isOptional() && v.get(this, (String)k) == null) {
                v.set(this, (String)k, cm.getOptionalDefault());
            }
        });
        this.meta.getHiddenProperties().forEach((k, v) -> {
            ClassMeta<?> cm = v.getClassMeta();
            if (cm.isOptional() && v.get(this, (String)k) == null) {
                v.set(this, (String)k, cm.getOptionalDefault());
            }
        });
        return b;
    }

    public T getBean(boolean create) {
        if (this.bean == null && create && Utils.ne(this.meta.getConstructorArgs())) {
            List<String> props = this.meta.getConstructorArgs();
            ConstructorInfo c = this.meta.getConstructor();
            Object[] args = new Object[props.size()];
            for (int i = 0; i < props.size(); ++i) {
                args[i] = this.propertyCache.remove(props.get(i));
            }
            try {
                this.bean = c.newInstance(args);
                this.propertyCache.forEach((k, v) -> this.put((String)k, v));
                this.propertyCache = null;
            }
            catch (IllegalArgumentException e) {
                throw ThrowableUtils.bex((Throwable)e, this.meta.getClassMeta().inner(), "IllegalArgumentException occurred on call to class constructor ''{0}'' with argument types ''{1}''", c.getSimpleName(), Json5Serializer.DEFAULT.toString(ClassUtils.getClasses(args)));
            }
            catch (Exception e) {
                throw ThrowableUtils.bex(e);
            }
        }
        return this.bean;
    }

    public final BeanSession getBeanSession() {
        return this.session;
    }

    @Override
    public ClassMeta<T> getClassMeta() {
        return this.meta.getClassMeta();
    }

    public BeanMeta<T> getMeta() {
        return this.meta;
    }

    public Map<String, Object> getProperties(String ... fields) {
        return new FilteredKeyMap<String, Object>(null, this, fields);
    }

    public BeanMapEntry getProperty(String propertyName) {
        BeanPropertyMeta p = this.getPropertyMeta(propertyName);
        if (p == null) {
            return null;
        }
        return new BeanMapEntry(this, p, propertyName);
    }

    public BeanPropertyMeta getPropertyMeta(String propertyName) {
        return this.meta.getPropertyMeta(propertyName);
    }

    public Object getRaw(Object property) {
        String pName = Utils.s(property);
        BeanPropertyMeta p = this.getPropertyMeta(pName);
        if (p == null) {
            return null;
        }
        return p.getRaw(this, pName);
    }

    @Override
    public Set<String> keySet() {
        if (this.meta.getDynaProperty() == null) {
            return this.meta.getProperties().keySet();
        }
        LinkedHashSet<String> l = CollectionUtils.set(new String[0]);
        this.meta.getProperties().forEach((k, v) -> {
            if (!"*".equals(k)) {
                l.add((String)k);
            }
        });
        try {
            l.addAll(this.meta.getDynaProperty().getDynaMap(this.bean).keySet());
        }
        catch (Exception e) {
            throw new BeanRuntimeException(e);
        }
        return l;
    }

    public BeanMap<T> load(Map entries) {
        this.putAll(entries);
        return this;
    }

    public BeanMap<T> load(Reader r, ReaderParser p) throws ParseException, IOException {
        this.putAll(JsonMap.ofText(r, (Parser)p));
        return this;
    }

    public BeanMap<T> load(String input) throws ParseException {
        this.putAll(JsonMap.ofJson(input));
        return this;
    }

    @Override
    public Object put(String property, Object value) {
        BeanPropertyMeta p = this.getPropertyMeta(property);
        if (p == null) {
            if (this.meta.getBeanContext().isIgnoreUnknownBeanProperties() || property.equals(this.typePropertyName)) {
                return this.meta.onWriteProperty(this.bean, property, null);
            }
            p = this.getPropertyMeta("*");
            if (p == null) {
                throw ThrowableUtils.bex(this.meta.getClassMeta(), "Bean property ''{0}'' not found.", property);
            }
        }
        return p.set(this, property, value);
    }

    public String resolveVars(String s) {
        return StringUtils.formatNamed(s, this);
    }

    protected Collection<BeanPropertyMeta> getProperties() {
        return this.meta.getProperties().values();
    }

    void setBean(Object bean) {
        this.bean = bean;
    }
}

