/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.marshaller;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;

public abstract class Marshaller {
    private final Serializer s;
    private final Parser p;

    protected Marshaller(Serializer s, Parser p) {
        this.s = s;
        this.p = p;
    }

    public Serializer getSerializer() {
        return this.s;
    }

    public Parser getParser() {
        return this.p;
    }

    public final void write(Object object, Object output) throws SerializeException, IOException {
        this.s.serialize(object, output);
    }

    public final <T> T read(Object input, Type type, Type ... args) throws ParseException, IOException {
        return this.p.parse(input, type, args);
    }

    public final <T> T read(Object input, Class<T> type) throws ParseException, IOException {
        return this.p.parse(input, type);
    }
}

