/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMFBuilder;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class SwapAnnotation {
    public static final Swap DEFAULT = SwapAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return SwapAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return SwapAnnotation.create().on(on);
    }

    public static Swap copy(Swap a, VarResolverSession r) {
        return ((Builder)SwapAnnotation.create().impl(a.impl()).mediaTypes(r.resolve(a.mediaTypes())).on(r.resolve(a.on())).onClass((Class[])a.onClass())).template(r.resolve(a.template())).value(a.value()).build();
    }

    public static class Builder
    extends TargetedAnnotationTMFBuilder {
        Class<?> impl = Void.TYPE;
        Class<?> value = Void.TYPE;
        String template = "";
        String[] mediaTypes = new String[0];

        protected Builder() {
            super(Swap.class);
        }

        public Swap build() {
            return new Impl(this);
        }

        public Builder impl(Class<?> value) {
            this.impl = value;
            return this;
        }

        public Builder mediaTypes(String ... value) {
            this.mediaTypes = value;
            return this;
        }

        public Builder template(String value) {
            this.template = value;
            return this;
        }

        public Builder value(Class<?> value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Swap[] value();
    }

    public static class Applier
    extends AnnotationApplier<Swap, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Swap.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Swap> ai, BeanContext.Builder b) {
            Swap a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(SwapAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Swap {
        private final Class<?> impl;
        private final Class<?> value;
        private final String template;
        private final String[] mediaTypes;

        Impl(Builder b) {
            super(b);
            this.impl = b.impl;
            this.mediaTypes = ArrayUtils.copyOf(b.mediaTypes);
            this.template = b.template;
            this.value = b.value;
            this.postConstruct();
        }

        @Override
        public Class<?> impl() {
            return this.impl;
        }

        @Override
        public String[] mediaTypes() {
            return this.mediaTypes;
        }

        @Override
        public String template() {
            return this.template;
        }

        @Override
        public Class<?> value() {
            return this.value;
        }
    }
}

