/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.util.Optional;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.reflect.ParamInfo;

public final class RemoteOperationArg {
    private final int index;
    private final HttpPartType partType;
    private final Optional<HttpPartSerializer> serializer;
    private final HttpPartSchema schema;

    RemoteOperationArg(int index, HttpPartType partType, HttpPartSchema schema) {
        this.index = index;
        this.partType = partType;
        this.serializer = BeanCreator.of(HttpPartSerializer.class).type(schema.getSerializer()).execute();
        this.schema = schema;
    }

    public String getName() {
        return this.schema.getName();
    }

    public boolean isSkipIfEmpty() {
        return this.schema.isSkipIfEmpty();
    }

    public int getIndex() {
        return this.index;
    }

    public HttpPartType getPartType() {
        return this.partType;
    }

    public Optional<HttpPartSerializer> getSerializer() {
        return this.serializer;
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }

    static RemoteOperationArg create(ParamInfo mpi) {
        int i = mpi.getIndex();
        if (mpi.hasAnnotation(Header.class)) {
            return new RemoteOperationArg(i, HttpPartType.HEADER, HttpPartSchema.create(Header.class, mpi));
        }
        if (mpi.hasAnnotation(Query.class)) {
            return new RemoteOperationArg(i, HttpPartType.QUERY, HttpPartSchema.create(Query.class, mpi));
        }
        if (mpi.hasAnnotation(FormData.class)) {
            return new RemoteOperationArg(i, HttpPartType.FORMDATA, HttpPartSchema.create(FormData.class, mpi));
        }
        if (mpi.hasAnnotation(Path.class)) {
            return new RemoteOperationArg(i, HttpPartType.PATH, HttpPartSchema.create(Path.class, mpi));
        }
        if (mpi.hasAnnotation(Content.class)) {
            return new RemoteOperationArg(i, HttpPartType.BODY, HttpPartSchema.create(Content.class, mpi));
        }
        return null;
    }
}

