/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.atom;

import java.util.Calendar;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.atom.Category;
import org.apache.juneau.dto.atom.CommonEntry;
import org.apache.juneau.dto.atom.Content;
import org.apache.juneau.dto.atom.Id;
import org.apache.juneau.dto.atom.Link;
import org.apache.juneau.dto.atom.Person;
import org.apache.juneau.dto.atom.Source;
import org.apache.juneau.dto.atom.Text;
import org.apache.juneau.dto.atom.Utils;
import org.apache.juneau.internal.FluentSetters;

@Bean(typeName="entry")
@FluentSetters
public class Entry
extends CommonEntry {
    private Content content;
    private Calendar published;
    private Source source;
    private Text summary;

    public Entry(Id id, Text title, Calendar updated) {
        super(id, title, updated);
    }

    public Entry(String id, String title, String updated) {
        super(id, title, updated);
    }

    public Entry() {
    }

    public Content getContent() {
        return this.content;
    }

    public Entry setContent(Content value) {
        this.content = value;
        return this;
    }

    public Calendar getPublished() {
        return this.published;
    }

    public Entry setPublished(Calendar value) {
        this.published = value;
        return this;
    }

    public Entry setPublished(String value) {
        this.setPublished(Utils.parseDateTime(value));
        return this;
    }

    public Source getSource() {
        return this.source;
    }

    public Entry setSource(Source value) {
        this.source = value;
        return this;
    }

    public Text getSummary() {
        return this.summary;
    }

    public Entry setSummary(Text value) {
        this.summary = value;
        return this;
    }

    public Entry setSummary(String value) {
        this.setSummary(new Text(value));
        return this;
    }

    @Override
    public Entry setBase(Object value) {
        super.setBase(value);
        return this;
    }

    @Override
    public Entry setLang(String value) {
        super.setLang(value);
        return this;
    }

    @Override
    public Entry setAuthors(Person ... value) {
        super.setAuthors(value);
        return this;
    }

    @Override
    public Entry setCategories(Category ... value) {
        super.setCategories(value);
        return this;
    }

    @Override
    public Entry setContributors(Person ... value) {
        super.setContributors(value);
        return this;
    }

    @Override
    public Entry setId(String value) {
        super.setId(value);
        return this;
    }

    @Override
    public Entry setId(Id value) {
        super.setId(value);
        return this;
    }

    @Override
    public Entry setLinks(Link ... value) {
        super.setLinks(value);
        return this;
    }

    @Override
    public Entry setRights(String value) {
        super.setRights(value);
        return this;
    }

    @Override
    public Entry setRights(Text value) {
        super.setRights(value);
        return this;
    }

    @Override
    public Entry setTitle(String value) {
        super.setTitle(value);
        return this;
    }

    @Override
    public Entry setTitle(Text value) {
        super.setTitle(value);
        return this;
    }

    @Override
    public Entry setUpdated(String value) {
        super.setUpdated(value);
        return this;
    }

    @Override
    public Entry setUpdated(Calendar value) {
        super.setUpdated(value);
        return this;
    }
}

