/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.juneau.MediaRange;
import org.apache.juneau.MediaType;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;

@BeanIgnore
public class MediaRanges {
    public static final MediaRanges EMPTY = new MediaRanges("");
    private static final Cache<String, MediaRanges> CACHE = Cache.of(String.class, MediaRanges.class).build();
    private final MediaRange[] ranges;
    private final String string;
    private static final Comparator<MediaRange> RANGE_COMPARATOR = (o1, o2) -> {
        int qCompare = Float.compare(o2.getQValue().floatValue(), o1.getQValue().floatValue());
        if (qCompare != 0) {
            return qCompare;
        }
        return o2.toString().compareTo(o1.toString());
    };

    public static MediaRanges of(String value) {
        return StringUtils.isEmpty(value) ? EMPTY : CACHE.get(value, () -> new MediaRanges(value));
    }

    public MediaRanges(String value) {
        this(MediaRanges.parse(value));
    }

    public MediaRanges(HeaderElement[] e) {
        this.ranges = new MediaRange[e.length];
        for (int i = 0; i < e.length; ++i) {
            this.ranges[i] = new MediaRange(e[i]);
        }
        Arrays.sort(this.ranges, RANGE_COMPARATOR);
        this.string = this.ranges.length == 1 ? this.ranges[0].toString() : StringUtils.join((Object[])this.ranges, ',');
    }

    public int match(List<? extends MediaType> mediaTypes) {
        MediaRange mr;
        float q2;
        if (this.string.isEmpty() || mediaTypes == null) {
            return -1;
        }
        int matchQuant = 0;
        int matchIndex = -1;
        float q = 0.0f;
        MediaRange[] mediaRangeArray = this.ranges;
        int n = mediaRangeArray.length;
        for (int i = 0; i < n && !((q2 = (mr = mediaRangeArray[i]).getQValue().floatValue()) < q) && q2 != 0.0f; ++i) {
            for (int i2 = 0; i2 < mediaTypes.size(); ++i2) {
                MediaType mt = mediaTypes.get(i2);
                int matchQuant2 = mr.match(mt, false);
                if (matchQuant2 <= matchQuant) continue;
                matchIndex = i2;
                matchQuant = matchQuant2;
                q = q2;
            }
        }
        return matchIndex;
    }

    public MediaRange getRange(int index) {
        if (index < 0 || index >= this.ranges.length) {
            return null;
        }
        return this.ranges[index];
    }

    public boolean hasSubtypePart(String part) {
        for (MediaRange mr : this.ranges) {
            if (!(mr.getQValue().floatValue() > 0.0f) || mr.getSubTypes().indexOf(part) < 0) continue;
            return true;
        }
        return false;
    }

    public List<MediaRange> toList() {
        return CollectionUtils.ulist(this.ranges);
    }

    public MediaRanges forEachRange(Consumer<MediaRange> action) {
        for (MediaRange r : this.ranges) {
            action.accept(r);
        }
        return this;
    }

    private static HeaderElement[] parse(String value) {
        return BasicHeaderValueParser.parseElements(StringUtils.emptyIfNull(StringUtils.trim(value)), null);
    }

    public String toString() {
        return this.string;
    }
}

