/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.StreamResource;
import org.apache.juneau.rest.StaticFileMapping;
import org.apache.juneau.utils.ClasspathResourceManager;

class StaticFiles {
    private final Class<?> resourceClass;
    private final String path;
    private final String location;
    private final Map<String, Object> responseHeaders;
    private final ClasspathResourceManager staticResourceManager;
    private final MimetypesFileTypeMap mimetypesFileTypeMap;

    StaticFiles(StaticFileMapping sfm, ClasspathResourceManager staticResourceManager, MimetypesFileTypeMap mimetypesFileTypeMap, Map<String, Object> staticFileResponseHeaders) {
        this.resourceClass = sfm.resourceClass;
        this.path = sfm.path;
        this.location = sfm.location;
        this.responseHeaders = sfm.responseHeaders != null ? sfm.responseHeaders : staticFileResponseHeaders;
        this.staticResourceManager = staticResourceManager;
        this.mimetypesFileTypeMap = mimetypesFileTypeMap;
    }

    String getPath() {
        return this.path;
    }

    StreamResource resolve(String p) throws IOException {
        if (p.startsWith(this.path)) {
            String remainder;
            String string = remainder = p.equals(this.path) ? "" : p.substring(this.path.length());
            if (remainder.isEmpty() || remainder.startsWith("/")) {
                String p2 = this.location + remainder;
                try (InputStream is = this.staticResourceManager.getStream(this.resourceClass, p2, null);){
                    if (is != null) {
                        int i = p2.lastIndexOf(47);
                        String name = i == -1 ? p2 : p2.substring(i + 1);
                        String mediaType = this.mimetypesFileTypeMap.getContentType(name);
                        StreamResource streamResource = new StreamResource(MediaType.forString((String)mediaType), this.responseHeaders, true, new Object[]{is});
                        return streamResource;
                    }
                }
            }
        }
        return null;
    }
}

