/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;
import org.apache.jena.sparql.util.XSDNumUtils;

public class NodeValueFloat
extends NodeValue {
    private final float value;

    public NodeValueFloat(float f) {
        this.value = f;
    }

    public NodeValueFloat(float f, Node n) {
        super(n);
        this.value = f;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    protected Node makeNode() {
        return NodeFactory.createLiteralDT(XSDNumUtils.stringForm(this.value), XSDDatatype.XSDfloat);
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.getNode() != null) {
            return super.asString();
        }
        return Float.toString(this.value);
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

