/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.property_functions.cardinal;

import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.spatial.CardinalDirection;
import org.apache.jena.geosparql.spatial.SearchEnvelope;
import org.apache.jena.geosparql.spatial.property_functions.GenericSpatialGeomPropertyFunction;
import org.apache.jena.geosparql.spatial.property_functions.SpatialArguments;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class GenericCardinalGeomPropertyFunction
extends GenericSpatialGeomPropertyFunction {
    protected abstract CardinalDirection getCardinalDirection();

    @Override
    protected SearchEnvelope buildSearchEnvelope(GeometryWrapper geometryWrapper, SRSInfo indexSRSInfo) {
        CardinalDirection direction = this.getCardinalDirection();
        SearchEnvelope searchEnvelope = SearchEnvelope.build(geometryWrapper, indexSRSInfo, direction);
        return searchEnvelope;
    }

    @Override
    protected boolean checkSecondFilter(SpatialArguments spatialArguments, GeometryWrapper targetGeometryWrapper) {
        SearchEnvelope searchEnvelope = spatialArguments.getSearchEnvelope();
        try {
            GeometryWrapper srs = targetGeometryWrapper.convertSRS(searchEnvelope.getSrsURI());
            Envelope targetEnvelope = srs.getEnvelope();
            boolean result = searchEnvelope.check(targetEnvelope);
            return result;
        }
        catch (MismatchedDimensionException | TransformException | FactoryException ex) {
            throw new ExprEvalException(ex.getMessage() + ": " + String.valueOf(targetGeometryWrapper.asLiteral()), ex);
        }
    }
}

