/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.metrics.MetricsProvider;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public class SimpleMetricsProvider
implements MetricsProvider {
    private MeterRegistry meterRegistry = new SimpleMeterRegistry();

    @Override
    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public void scrape(HttpAction action) {
        HttpServletResponse response = action.getResponse();
        StringBuilder sbuff = new StringBuilder(1000);
        try {
            this.meterRegistry.forEachMeter(meter -> {
                Meter.Id id = meter.getId();
                this.output(sbuff, "Meter %s", id);
                this.output(sbuff, "  Name     %s", id.getName());
                this.output(sbuff, "  BaseUnit %s", id.getBaseUnit());
                id.getTags().forEach(tag -> this.output(sbuff, "    Tag %s %s", tag.getKey(), tag.getValue()));
                meter.measure().forEach(measurement -> this.output(sbuff, "    Measure %s %s", new Object[]{measurement.getStatistic(), measurement.getValue()}));
            });
            String txt = sbuff.toString();
            action.setResponseContentType("text/plain");
            try (ServletOutputStream x = action.getResponseOutputStream();){
                x.print(txt);
            }
        }
        catch (Throwable th) {
            ServletOps.error(500);
        }
    }

    private void output(StringBuilder sbuff, String fmt, Object ... args) {
        String str2 = fmt.formatted(args);
        sbuff.append(str2);
        if (!str2.endsWith("\n")) {
            sbuff.append("\n");
        }
    }
}

