/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIteratorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryIteratorTiming
extends QueryIteratorWrapper {
    private static Logger log = LoggerFactory.getLogger(QueryIteratorTiming.class);
    public static final int NotStarted = -2;
    public static final int NotFinished = -1;
    private Timer timer = null;
    private long milliseconds = -2L;

    public static QueryIteratorTiming time(QueryIterator iter) {
        return new QueryIteratorTiming(iter);
    }

    private QueryIteratorTiming(QueryIterator iter) {
        super(iter);
    }

    @Override
    protected boolean hasNextBinding() {
        this.start();
        return super.hasNextBinding();
    }

    @Override
    protected Binding moveToNextBinding() {
        this.start();
        return super.moveToNextBinding();
    }

    @Override
    protected void closeIterator() {
        super.closeIterator();
        this.stop();
    }

    private void start() {
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.startTimer();
            this.milliseconds = -1L;
        }
    }

    private void stop() {
        if (this.timer == null) {
            this.milliseconds = 0L;
            return;
        }
        this.milliseconds = this.timer.endTimer();
        log.info("Execution: {} milliseconds", (Object)this.milliseconds);
    }

    public long getMillis() {
        return this.milliseconds;
    }
}

