/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.backends.cassandra.init.configuration.KeyspaceConfiguration;

public class KeyspacesConfiguration {
    public static final String CASSANDRA_KEYSPACE = "cassandra.keyspace";
    public static final String CASSANDRA_CACHE_KEYSPACE = "cassandra.keyspace.cache";
    public static final String REPLICATION_FACTOR = "cassandra.replication.factor";
    private static final String DEFAULT_KEYSPACE = "apache_james";
    private static final String DEFAULT_CACHE_KEYSPACE = "apache_james_cache";
    private static final int DEFAULT_REPLICATION_FACTOR = 1;
    private final String keyspace;
    private final String cacheKeyspace;
    private final int replicationFactor;
    private final boolean durableWrites;

    public static Builder builder() {
        return new Builder();
    }

    public static KeyspacesConfiguration from(Configuration configuration) {
        return KeyspacesConfiguration.builder().keyspace(Optional.ofNullable(configuration.getString(CASSANDRA_KEYSPACE, null))).cacheKeyspace(Optional.ofNullable(configuration.getString(CASSANDRA_CACHE_KEYSPACE, null))).replicationFactor(Optional.ofNullable(configuration.getInteger(REPLICATION_FACTOR, null))).build();
    }

    public KeyspacesConfiguration(String keyspace, String cacheKeyspace, int replicationFactor, boolean durableWrites) {
        this.keyspace = keyspace;
        this.cacheKeyspace = cacheKeyspace;
        this.replicationFactor = replicationFactor;
        this.durableWrites = durableWrites;
    }

    public KeyspaceConfiguration mainKeyspaceConfiguration() {
        return KeyspaceConfiguration.builder().keyspace(this.keyspace).replicationFactor(this.replicationFactor).durableWrites(this.durableWrites);
    }

    public KeyspaceConfiguration cacheKeyspaceConfiguration() {
        return KeyspaceConfiguration.builder().keyspace(this.cacheKeyspace).replicationFactor(1).durableWrites(this.durableWrites);
    }

    public final boolean equals(Object o) {
        if (o instanceof KeyspacesConfiguration) {
            KeyspacesConfiguration that = (KeyspacesConfiguration)o;
            return Objects.equals(this.replicationFactor, that.replicationFactor) && Objects.equals(this.durableWrites, that.durableWrites) && Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.cacheKeyspace, that.cacheKeyspace);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.keyspace, this.cacheKeyspace, this.replicationFactor, this.durableWrites);
    }

    public static class Builder {
        private Optional<String> keyspace = Optional.empty();
        private Optional<String> cacheKeyspace = Optional.empty();
        private Optional<Integer> replicationFactor = Optional.empty();
        private Optional<Boolean> durableWrites = Optional.empty();

        public Builder keyspace(Optional<String> keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public Builder cacheKeyspace(Optional<String> cacheKeyspace) {
            this.cacheKeyspace = cacheKeyspace;
            return this;
        }

        public Builder cacheKeyspace(String cacheKeyspace) {
            return this.cacheKeyspace(Optional.of(cacheKeyspace));
        }

        public Builder keyspace(String keyspace) {
            return this.keyspace(Optional.of(keyspace));
        }

        public Builder replicationFactor(Optional<Integer> replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public Builder replicationFactor(int replicationFactor) {
            return this.replicationFactor(Optional.of(replicationFactor));
        }

        public Builder disableDurableWrites() {
            this.durableWrites = Optional.of(false);
            return this;
        }

        public KeyspacesConfiguration build() {
            String cacheKeyspace;
            String keyspace = this.keyspace.orElse(KeyspacesConfiguration.DEFAULT_KEYSPACE);
            Preconditions.checkState((!keyspace.equals(cacheKeyspace = this.cacheKeyspace.orElse(KeyspacesConfiguration.DEFAULT_CACHE_KEYSPACE)) ? 1 : 0) != 0, (Object)"'cassandra.keyspace' and 'cassandra.keyspace.cache' needs to have distinct values");
            return new KeyspacesConfiguration(keyspace, cacheKeyspace, this.replicationFactor.orElse(1), this.durableWrites.orElse(true));
        }
    }
}

