/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.GetQuotaRequest;
import org.apache.james.imap.message.response.QuotaResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GetQuotaProcessor
extends AbstractMailboxProcessor<GetQuotaRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> CAPABILITIES = ImmutableList.of((Object)ImapConstants.SUPPORTS_QUOTA);
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;

    @Inject
    public GetQuotaProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, MetricFactory metricFactory) {
        super(GetQuotaRequest.class, mailboxManager, factory, metricFactory);
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected Mono<Void> processRequestReactive(GetQuotaRequest request, ImapSession session, ImapProcessor.Responder responder) {
        try {
            QuotaRoot quotaRoot = this.quotaRootResolver.fromString(request.getQuotaRoot());
            return this.hasRight(quotaRoot, session).flatMap(hasRight -> {
                if (hasRight.booleanValue()) {
                    return Mono.from((Publisher)this.quotaManager.getQuotasReactive(quotaRoot)).doOnNext(quotas -> this.respond(responder, request, quotaRoot, (QuotaManager.Quotas)quotas));
                }
                return Mono.fromRunnable(() -> this.respondNo(request, responder));
            }).then().onErrorResume(MailboxException.class, e -> {
                this.taggedBad(request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX);
                return Mono.empty();
            });
        }
        catch (MailboxException me) {
            this.taggedBad(request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX);
            return Mono.empty();
        }
    }

    private void respondNo(GetQuotaRequest request, ImapProcessor.Responder responder) {
        Object[] params = new Object[]{MailboxACL.Right.Read.toString(), request.getCommand().getName(), "Any mailbox of this user USER"};
        HumanReadableText humanReadableText = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
        this.no(request, responder, humanReadableText);
    }

    private void respond(ImapProcessor.Responder responder, GetQuotaRequest request, QuotaRoot quotaRoot, QuotaManager.Quotas quotas) {
        if (((QuotaCountLimit)quotas.getMessageQuota().getLimit()).isLimited()) {
            responder.respond(new QuotaResponse("MESSAGE", quotaRoot.getValue(), quotas.getMessageQuota()));
        }
        if (((QuotaSizeLimit)quotas.getStorageQuota().getLimit()).isLimited()) {
            responder.respond(new QuotaResponse("STORAGE", quotaRoot.getValue(), quotas.getStorageQuota()));
        }
        this.okComplete(request, responder);
    }

    private Mono<Boolean> hasRight(QuotaRoot quotaRoot, ImapSession session) {
        MailboxSession mailboxSession = session.getMailboxSession();
        return Flux.from((Publisher)this.quotaRootResolver.retrieveAssociatedMailboxes(quotaRoot, mailboxSession)).filter(Throwing.predicate(mailbox -> this.getMailboxManager().hasRight(mailbox, MailboxACL.Right.Read, mailboxSession)).sneakyThrow()).hasElements();
    }

    @Override
    protected MDCBuilder mdc(GetQuotaRequest request) {
        return MDCBuilder.create().addToContext("action", "GET_QUOTA").addToContext("quotaRoot", request.getQuotaRoot());
    }
}

