/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns.internal;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Stash;
import org.apache.pekko.actor.StashSupport;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.UnrestrictedStash;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.dispatch.DequeBasedMessageQueueSemantics;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.Inet;
import org.apache.pekko.io.Tcp;
import org.apache.pekko.io.Tcp$PeerClosed$;
import org.apache.pekko.io.Tcp$Write$;
import org.apache.pekko.io.dns.ResourceRecord;
import org.apache.pekko.io.dns.internal.DnsClient;
import org.apache.pekko.io.dns.internal.Message;
import org.apache.pekko.io.dns.internal.Message$;
import org.apache.pekko.io.dns.internal.MessageFlags$;
import org.apache.pekko.io.dns.internal.ResponseCode$;
import org.apache.pekko.io.dns.internal.TcpDnsClient$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd!B\n\u0015\u0001i\u0001\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u0011a\u0002!\u0011!Q\u0001\neB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006\u0013\u0002!\tE\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001K\u0011\u0019\u0001\u0006\u0001)A\u0005\u0017\"9\u0011\u000b\u0001b\u0001\n\u0003Q\u0005B\u0002*\u0001A\u0003%1\nC\u0003T\u0001\u0011\u0005A\u000bC\u0004`\u0001E\u0005I\u0011\u00011\t\u000b-\u0004A\u0011\u00027\b\u0011\u0005-A\u0003#\u0001\u0015\u0003\u001b1qa\u0005\u000b\t\u0002Q\ty\u0001\u0003\u0004C\u001d\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003'qA\u0011AA\u000b\u0011\u001d\t\tC\u0004C\u0001\u0003GAq!a\n\u000f\t\u0003\tIC\u0001\u0007UGB$en]\"mS\u0016tGO\u0003\u0002\u0016-\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u00181\u0005\u0019AM\\:\u000b\u0005eQ\u0012AA5p\u0015\tYB$A\u0003qK.\\wN\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<7#\u0002\u0001\"O5\u0002\u0004C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)W5\t\u0011F\u0003\u0002+5\u0005)\u0011m\u0019;pe&\u0011A&\u000b\u0002\u0006\u0003\u000e$xN\u001d\t\u0003Q9J!aL\u0015\u0003\u0019\u0005\u001bGo\u001c:M_\u001e<\u0017N\\4\u0011\u0005!\n\u0014B\u0001\u001a*\u0005\u0015\u0019F/Y:i\u0003\r!8\r]\u0002\u0001!\tAc'\u0003\u00028S\tA\u0011i\u0019;peJ+g-\u0001\u0002ogB\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0004]\u0016$(\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0003=\tgn]<feJ+7-\u001b9jK:$\u0018A\u0002\u001fj]&$h\b\u0006\u0003E\r\u001eC\u0005CA#\u0001\u001b\u0005!\u0002\"B\u001a\u0005\u0001\u0004)\u0004\"\u0002\u001d\u0005\u0001\u0004I\u0004\"B!\u0005\u0001\u0004)\u0014a\u0002:fG\u0016Lg/Z\u000b\u0002\u0017B\u0011A*T\u0007\u0002\u0001%\u0011aj\u000b\u0002\b%\u0016\u001cW-\u001b<f\u0003\u0011IG\r\\3\u0002\u000b%$G.\u001a\u0011\u0002\u0015\r|gN\\3di&tw-A\u0006d_:tWm\u0019;j]\u001e\u0004\u0013!\u0002:fC\u0012LHcA&V/\")aK\u0003a\u0001k\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\t\u000faS\u0001\u0013!a\u00013\u00061!-\u001e4gKJ\u0004\"AW/\u000e\u0003mS!\u0001\u0018\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003=n\u0013!BQ=uKN#(/\u001b8h\u0003=\u0011X-\u00193zI\u0011,g-Y;mi\u0012\u0012T#A1+\u0005e\u00137&A2\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017!C;oG\",7m[3e\u0015\tA7%\u0001\u0006b]:|G/\u0019;j_:L!A[3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qCJ\u001cXMU3ta>t7/\u001a\u000b\u0003[v\u0004\"A\u001c>\u000f\u0005=DhB\u00019x\u001d\t\thO\u0004\u0002sk:\u00111\u000f^\u0007\u00029%\u00111\u0004H\u0005\u00033iI!a\u0006\r\n\u0005U1\u0012BA=\u0015\u0003%!en]\"mS\u0016tG/\u0003\u0002|y\n1\u0011I\\:xKJT!!\u001f\u000b\t\u000byd\u0001\u0019A-\u0002\t\u0011\fG/\u0019\u0015\u0004\u0001\u0005\u0005\u0001\u0003BA\u0002\u0003\u000fi!!!\u0002\u000b\u0005!T\u0012\u0002BA\u0005\u0003\u000b\u00111\"\u00138uKJt\u0017\r\\!qS\u0006aAk\u00199E]N\u001cE.[3oiB\u0011QID\n\u0003\u001d\u0005\"\"!!\u0004\u0002\u0019\u0015t7m\u001c3f\u0019\u0016tw\r\u001e5\u0015\u0007e\u000b9\u0002C\u0004\u0002\u001aA\u0001\r!a\u0007\u0002\r1,gn\u001a;i!\r\u0011\u0013QD\u0005\u0004\u0003?\u0019#aA%oi\u0006aA-Z2pI\u0016dUM\\4uQR!\u00111DA\u0013\u0011\u0015q\u0018\u00031\u0001Z\u00031!\bN]8x\r\u0006LG.\u001e:f)\u0019\tY#!\r\u0002LA\u0019!%!\f\n\u0007\u0005=2E\u0001\u0003V]&$\bbBA\u001a%\u0001\u0007\u0011QG\u0001\b[\u0016\u001c8/Y4f!\u0011\t9$!\u0012\u000f\t\u0005e\u0012\u0011\t\t\u0004\u0003w\u0019SBAA\u001f\u0015\r\ty\u0004N\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r3%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\nIE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007\u001a\u0003bBA'%\u0001\u0007\u0011qJ\u0001\u0006G\u0006,8/\u001a\t\u0006E\u0005E\u0013QK\u0005\u0004\u0003'\u001a#AB(qi&|g\u000e\u0005\u0003\u0002X\u0005\u0005d\u0002BA-\u0003;rA!a\u000f\u0002\\%\tA%C\u0002\u0002`\r\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002d\u0005\u0015$!\u0003+ie><\u0018M\u00197f\u0015\r\tyf\t")
@InternalApi
public class TcpDnsClient
implements ActorLogging,
Stash {
    public final ActorRef org$apache$pekko$io$dns$internal$TcpDnsClient$$tcp;
    public final InetSocketAddress org$apache$pekko$io$dns$internal$TcpDnsClient$$ns;
    public final ActorRef org$apache$pekko$io$dns$internal$TcpDnsClient$$answerRecipient;
    private final PartialFunction<Object, BoxedUnit> idle;
    private final PartialFunction<Object, BoxedUnit> connecting;
    private Vector<Envelope> org$apache$pekko$actor$StashSupport$$theStash;
    private int org$apache$pekko$actor$StashSupport$$capacity;
    private DequeBasedMessageQueueSemantics mailbox;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    public static void throwFailure(String message, Option<Throwable> cause) {
        TcpDnsClient$.MODULE$.throwFailure(message, cause);
    }

    public static int decodeLength(ByteString data) {
        return TcpDnsClient$.MODULE$.decodeLength(data);
    }

    public static ByteString encodeLength(int length) {
        return TcpDnsClient$.MODULE$.encodeLength(length);
    }

    @Override
    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$postStop() {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        UnrestrictedStash.preRestart$(this, reason, message);
    }

    @Override
    public void postStop() throws Exception {
        UnrestrictedStash.postStop$(this);
    }

    @Override
    public void stash() {
        StashSupport.stash$(this);
    }

    @Override
    public void prepend(Seq<Envelope> others) {
        StashSupport.prepend$(this, others);
    }

    @Override
    public void unstash() {
        StashSupport.unstash$(this);
    }

    @Override
    public void unstashAll() {
        StashSupport.unstashAll$(this);
    }

    @Override
    @InternalStableApi
    public void unstashAll(Function1<Object, Object> filterPredicate) {
        StashSupport.unstashAll$(this, filterPredicate);
    }

    @Override
    @InternalStableApi
    public Vector<Envelope> clearStash() {
        return StashSupport.clearStash$(this);
    }

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public Vector<Envelope> org$apache$pekko$actor$StashSupport$$theStash() {
        return this.org$apache$pekko$actor$StashSupport$$theStash;
    }

    @Override
    public void org$apache$pekko$actor$StashSupport$$theStash_$eq(Vector<Envelope> x$1) {
        this.org$apache$pekko$actor$StashSupport$$theStash = x$1;
    }

    @Override
    public int org$apache$pekko$actor$StashSupport$$capacity() {
        return this.org$apache$pekko$actor$StashSupport$$capacity;
    }

    @Override
    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    @Override
    public final void org$apache$pekko$actor$StashSupport$_setter_$org$apache$pekko$actor$StashSupport$$capacity_$eq(int x$1) {
        this.org$apache$pekko$actor$StashSupport$$capacity = x$1;
    }

    @Override
    public void org$apache$pekko$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$1) {
        this.mailbox = x$1;
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return this.idle();
    }

    public PartialFunction<Object, BoxedUnit> idle() {
        return this.idle;
    }

    public PartialFunction<Object, BoxedUnit> connecting() {
        return this.connecting;
    }

    public PartialFunction<Object, BoxedUnit> ready(ActorRef connection, ByteString buffer) {
        return new Serializable(this, connection, buffer){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TcpDnsClient $outer;
            private final ActorRef connection$1;
            private final ByteString buffer$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Tcp.CommandFailed commandFailed;
                if (x1 instanceof Message) {
                    ByteString bytes = ((Message)x1).write();
                    this.connection$1.$bang(Tcp$Write$.MODULE$.apply(TcpDnsClient$.MODULE$.encodeLength(bytes.length()).$plus$plus(bytes)), this.$outer.self());
                    return (B1)BoxedUnit.UNIT;
                }
                if (x1 instanceof Tcp.CommandFailed && (commandFailed = (Tcp.CommandFailed)x1).cmd() instanceof Tcp.Write) {
                    TcpDnsClient$.MODULE$.throwFailure("Write failed", commandFailed.cause());
                    return (B1)BoxedUnit.UNIT;
                }
                if (x1 instanceof Tcp.Received) {
                    ByteString newData = ((Tcp.Received)x1).data();
                    ByteString data = this.buffer$1.$plus$plus(newData);
                    int prefixSize = 2;
                    if (data.length() < prefixSize) {
                        this.$outer.context().become(this.$outer.ready(this.connection$1, data));
                        return (B1)BoxedUnit.UNIT;
                    }
                    int expectedPayloadLength = TcpDnsClient$.MODULE$.decodeLength(data);
                    if (data.drop(prefixSize).length() < expectedPayloadLength) {
                        this.$outer.context().become(this.$outer.ready(this.connection$1, data));
                        return (B1)BoxedUnit.UNIT;
                    }
                    this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$answerRecipient.$bang(this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$parseResponse(data.drop(prefixSize)), this.$outer.self());
                    this.$outer.context().become(this.$outer.ready(this.connection$1, ByteString$.MODULE$.empty()));
                    if (data.length() > prefixSize + expectedPayloadLength) {
                        this.$outer.self().$bang(new Tcp.Received(data.drop(prefixSize + expectedPayloadLength)), this.$outer.self());
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                if (Tcp$PeerClosed$.MODULE$.equals(x1)) {
                    this.$outer.context().unwatch(this.connection$1);
                    this.$outer.context().become(this.$outer.idle());
                    return (B1)BoxedUnit.UNIT;
                }
                if (x1 instanceof Terminated) {
                    ActorRef actorRef = ((Terminated)x1).actor();
                    ActorRef actorRef2 = this.connection$1;
                    if (!(actorRef2 != null ? !((Object)actorRef2).equals(actorRef) : actorRef != null)) {
                        TcpDnsClient$.MODULE$.throwFailure("TCP connection terminated without closing (register timeout?)", (Option<Throwable>)None$.MODULE$);
                        return (B1)BoxedUnit.UNIT;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                if (x1 instanceof Message) {
                    return true;
                }
                if (x1 instanceof Tcp.CommandFailed && ((Tcp.CommandFailed)x1).cmd() instanceof Tcp.Write) {
                    return true;
                }
                if (x1 instanceof Tcp.Received) {
                    return true;
                }
                if (Tcp$PeerClosed$.MODULE$.equals(x1)) {
                    return true;
                }
                if (x1 instanceof Terminated) {
                    ActorRef actorRef = ((Terminated)x1).actor();
                    ActorRef actorRef2 = this.connection$1;
                    if (!(actorRef2 != null ? !((Object)actorRef2).equals(actorRef) : actorRef != null)) {
                        return true;
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.connection$1 = connection$1;
                this.buffer$1 = buffer$1;
            }
        };
    }

    public ByteString ready$default$2() {
        return ByteString$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     */
    public DnsClient.Answer org$apache$pekko$io$dns$internal$TcpDnsClient$$parseResponse(ByteString data) {
        void var5_7;
        void var4_6;
        Seq<ResourceRecord> seq;
        Seq<ResourceRecord> seq2;
        Message msg = Message$.MODULE$.parse(data);
        this.log().debug("Decoded TCP DNS response [{}]", msg);
        if (MessageFlags$.MODULE$.isTruncated$extension(msg.flags())) {
            this.log().warning("TCP DNS response truncated");
        }
        short responseCode$extension_$this = msg.flags();
        Enumeration.Value value = ResponseCode$.MODULE$.apply(responseCode$extension_$this & 0xF);
        Enumeration.Value value2 = ResponseCode$.MODULE$.SUCCESS();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            seq2 = msg.answerRecs();
            seq = msg.additionalRecs();
        } else {
            seq2 = Nil$.MODULE$;
            seq = Nil$.MODULE$;
        }
        Seq<ResourceRecord> seq3 = seq;
        Seq<ResourceRecord> recs = seq2;
        Seq<ResourceRecord> additionalRecs = seq3;
        return new DnsClient.Answer(msg.id(), (Seq<ResourceRecord>)var4_6, (Seq<ResourceRecord>)var5_7);
    }

    public TcpDnsClient(ActorRef tcp, InetSocketAddress ns, ActorRef answerRecipient) {
        this.org$apache$pekko$io$dns$internal$TcpDnsClient$$tcp = tcp;
        this.org$apache$pekko$io$dns$internal$TcpDnsClient$$ns = ns;
        this.org$apache$pekko$io$dns$internal$TcpDnsClient$$answerRecipient = answerRecipient;
        Actor.$init$(this);
        StashSupport.$init$(this);
        this.idle = new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TcpDnsClient $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof Message) {
                    this.$outer.stash();
                    this.$outer.log().debug("Connecting to [{}]", this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$ns);
                    this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$tcp.$bang(new Tcp.Connect(this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$ns, (Option<InetSocketAddress>)None$.MODULE$, (Iterable<Inet.SocketOption>)Nil$.MODULE$, (Option<FiniteDuration>)None$.MODULE$, false), this.$outer.self());
                    this.$outer.context().become(this.$outer.connecting());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof Message;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.connecting = new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ TcpDnsClient $outer;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Tcp.CommandFailed commandFailed;
                if (x2 instanceof Tcp.CommandFailed && (commandFailed = (Tcp.CommandFailed)x2).cmd() instanceof Tcp.Connect) {
                    TcpDnsClient$.MODULE$.throwFailure(new StringBuilder(41).append("Failed to connect to TCP DNS server at [").append(this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$ns).append("]").toString(), commandFailed.cause());
                    return (B1)BoxedUnit.UNIT;
                }
                if (x2 instanceof Tcp.Connected) {
                    this.$outer.log().debug("Connected to TCP address [{}]", this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$ns);
                    TcpDnsClient tcpDnsClient = this.$outer;
                    if (tcpDnsClient == null) {
                        throw null;
                    }
                    TcpDnsClient sender_this = tcpDnsClient;
                    Object var5_4 = null;
                    ActorRef connection = Actor.sender$(sender_this);
                    this.$outer.context().become(this.$outer.ready(connection, this.$outer.ready$default$2()));
                    this.$outer.context().watch(connection);
                    connection.$bang(new Tcp.Register(this.$outer.self(), false, true), this.$outer.self());
                    this.$outer.unstashAll();
                    return (B1)BoxedUnit.UNIT;
                }
                if (x2 instanceof Message) {
                    this.$outer.stash();
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Object x2) {
                if (x2 instanceof Tcp.CommandFailed && ((Tcp.CommandFailed)x2).cmd() instanceof Tcp.Connect) {
                    return true;
                }
                if (x2 instanceof Tcp.Connected) {
                    return true;
                }
                return x2 instanceof Message;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        Statics.releaseFence();
    }
}

