/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class IrQuantifier {
    private final int atLeast;
    private final Optional<Integer> atMost;
    private final boolean greedy;

    public static IrQuantifier zeroOrMore(boolean greedy) {
        return new IrQuantifier(0, Optional.empty(), greedy);
    }

    public static IrQuantifier oneOrMore(boolean greedy) {
        return new IrQuantifier(1, Optional.empty(), greedy);
    }

    public static IrQuantifier zeroOrOne(boolean greedy) {
        return new IrQuantifier(0, Optional.of(1), greedy);
    }

    public static IrQuantifier range(Optional<Integer> atLeast, Optional<Integer> atMost, boolean greedy) {
        return new IrQuantifier(atLeast.orElse(0), atMost, greedy);
    }

    public IrQuantifier(int atLeast, Optional<Integer> atMost, boolean greedy) {
        this.atLeast = atLeast;
        this.atMost = Objects.requireNonNull(atMost, "atMost is null");
        this.greedy = greedy;
    }

    public int getAtLeast() {
        return this.atLeast;
    }

    public Optional<Integer> getAtMost() {
        return this.atMost;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrQuantifier o = (IrQuantifier)obj;
        return this.atLeast == o.atLeast && Objects.equals(this.atMost, o.atMost) && this.greedy == o.greedy;
    }

    public int hashCode() {
        return Objects.hash(this.atLeast, this.atMost, this.greedy);
    }

    public String toString() {
        return String.format("{%s, %s}", this.atLeast, this.atMost.map(Object::toString).orElse("\u221e"));
    }

    public static void serialize(IrQuantifier quantifier, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)quantifier.atLeast, (ByteBuffer)byteBuffer);
        if (quantifier.atMost.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)quantifier.atMost.get(), (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)quantifier.greedy, (ByteBuffer)byteBuffer);
    }

    public static void serialize(IrQuantifier quantifier, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)quantifier.atLeast, (OutputStream)stream);
        if (quantifier.atMost.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((int)quantifier.atMost.get(), (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)quantifier.greedy, (OutputStream)stream);
    }

    public static IrQuantifier deserialize(ByteBuffer byteBuffer) {
        int atLeast = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        boolean hasAtMost = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
        Optional<Integer> atMost = hasAtMost ? Optional.of(ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)) : Optional.empty();
        boolean greedy = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
        return new IrQuantifier(atLeast, atMost, greedy);
    }
}

