/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.distribute;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelLocation;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.NodeDistribution;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.WriteFragmentParallelPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.SubPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.IdentitySinkNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.execution.querystats.PlanOptimizersStatsCollector;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.distribute.AddExchangeNodes;
import org.apache.iotdb.db.queryengine.plan.relational.planner.distribute.SubPlanGenerator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.distribute.TableDistributedPlanGenerator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.distribute.TableModelQueryFragmentPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OutputNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.DataNodeLocationSupplierFactory;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.DistributedOptimizeFactory;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.tsfile.read.common.type.Type;

public class TableDistributedPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final LogicalQueryPlan logicalQueryPlan;
    private final MPPQueryContext mppQueryContext;
    private final List<PlanOptimizer> optimizers;
    private final Metadata metadata;
    private final DataNodeLocationSupplierFactory.DataNodeLocationSupplier dataNodeLocationSupplier;

    @TestOnly
    public TableDistributedPlanner(Analysis analysis, SymbolAllocator symbolAllocator, LogicalQueryPlan logicalQueryPlan, Metadata metadata, DataNodeLocationSupplierFactory.DataNodeLocationSupplier dataNodeLocationSupplier) {
        this(analysis, symbolAllocator, logicalQueryPlan, metadata, new DistributedOptimizeFactory(new PlannerContext(metadata, new InternalTypeManager())).getPlanOptimizers(), dataNodeLocationSupplier);
    }

    public TableDistributedPlanner(Analysis analysis, SymbolAllocator symbolAllocator, LogicalQueryPlan logicalQueryPlan, Metadata metadata, List<PlanOptimizer> distributedOptimizers, DataNodeLocationSupplierFactory.DataNodeLocationSupplier dataNodeLocationSupplier) {
        this.analysis = analysis;
        this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        this.logicalQueryPlan = logicalQueryPlan;
        this.mppQueryContext = logicalQueryPlan.getContext();
        this.optimizers = distributedOptimizers;
        this.metadata = metadata;
        this.dataNodeLocationSupplier = dataNodeLocationSupplier;
    }

    public DistributedQueryPlan plan() {
        TableDistributedPlanGenerator.PlanContext planContext = new TableDistributedPlanGenerator.PlanContext();
        PlanNode outputNodeWithExchange = this.generateDistributedPlanWithOptimize(planContext);
        if (this.analysis.isQuery()) {
            this.analysis.getRespDatasetHeader().setTableColumnToTsBlockIndexMap((OutputNode)outputNodeWithExchange);
        }
        this.adjustUpStream(outputNodeWithExchange, planContext);
        return this.generateDistributedPlan(outputNodeWithExchange, planContext.nodeDistributionMap);
    }

    public PlanNode generateDistributedPlanWithOptimize(TableDistributedPlanGenerator.PlanContext planContext) {
        List<PlanNode> distributedPlanResult = new TableDistributedPlanGenerator(this.mppQueryContext, this.analysis, this.symbolAllocator, this.dataNodeLocationSupplier).genResult(this.logicalQueryPlan.getRootNode(), planContext);
        Preconditions.checkArgument((distributedPlanResult.size() == 1 ? 1 : 0) != 0, (Object)"Root node must return only one");
        PlanNode distributedPlan = distributedPlanResult.get(0);
        if (this.analysis.isQuery()) {
            for (PlanOptimizer optimizer : this.optimizers) {
                distributedPlan = optimizer.optimize(distributedPlan, new PlanOptimizer.Context(this.mppQueryContext.getSession(), this.analysis, this.metadata, this.mppQueryContext, new SymbolAllocator(), this.mppQueryContext.getQueryId(), WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector()));
            }
        }
        this.symbolAllocator.getTypes().allTableModelTypes().forEach((k, v) -> this.mppQueryContext.getTypeProvider().putTableModelType((Symbol)k, (Type)v));
        return new AddExchangeNodes(this.mppQueryContext).addExchangeNodes(distributedPlan, planContext);
    }

    private DistributedQueryPlan generateDistributedPlan(PlanNode outputNodeWithExchange, Map<PlanNodeId, NodeDistribution> nodeDistributionMap) {
        List<FragmentInstance> fragmentInstances;
        SubPlan subPlan = new SubPlanGenerator().splitToSubPlan(this.logicalQueryPlan.getContext().getQueryId(), outputNodeWithExchange);
        subPlan.getPlanFragment().setRoot(true);
        List<FragmentInstance> list = fragmentInstances = this.mppQueryContext.isQuery() ? new TableModelQueryFragmentPlanner(subPlan, this.analysis, this.mppQueryContext, nodeDistributionMap).parallelPlan() : new WriteFragmentParallelPlanner(subPlan, this.analysis, this.mppQueryContext, WritePlanNode::splitByPartition).parallelPlan();
        if (this.mppQueryContext.isQuery()) {
            this.setSinkForRootInstance(subPlan, fragmentInstances);
        }
        return new DistributedQueryPlan(subPlan, fragmentInstances);
    }

    public void setSinkForRootInstance(SubPlan subPlan, List<FragmentInstance> instances) {
        FragmentInstance rootInstance = null;
        for (FragmentInstance instance : instances) {
            if (!instance.getFragment().getId().equals(subPlan.getPlanFragment().getId())) continue;
            rootInstance = instance;
            break;
        }
        if (rootInstance == null) {
            return;
        }
        IdentitySinkNode sinkNode = new IdentitySinkNode(this.mppQueryContext.getQueryId().genPlanNodeId(), Collections.singletonList(rootInstance.getFragment().getPlanNodeTree()), Collections.singletonList(new DownStreamChannelLocation(this.mppQueryContext.getLocalDataBlockEndpoint(), this.mppQueryContext.getResultNodeContext().getVirtualFragmentInstanceId().toThrift(), this.mppQueryContext.getResultNodeContext().getVirtualResultNodeId().getId())));
        this.mppQueryContext.getResultNodeContext().setUpStream(rootInstance.getHostDataNode().mPPDataExchangeEndPoint, rootInstance.getId(), sinkNode.getPlanNodeId());
        rootInstance.getFragment().setPlanNodeTree(sinkNode);
    }

    private void adjustUpStream(PlanNode root, TableDistributedPlanGenerator.PlanContext context) {
        if (!context.hasExchangeNode) {
            return;
        }
        this.adjustUpStreamHelper(root, context, new HashMap<TRegionReplicaSet, IdentitySinkNode>());
    }

    private void adjustUpStreamHelper(PlanNode root, TableDistributedPlanGenerator.PlanContext context, Map<TRegionReplicaSet, IdentitySinkNode> regionNodeMap) {
        for (PlanNode child : root.getChildren()) {
            this.adjustUpStreamHelper(child, context, regionNodeMap);
            if (!(child instanceof ExchangeNode)) continue;
            ExchangeNode exchangeNode = (ExchangeNode)child;
            IdentitySinkNode identitySinkNode = new IdentitySinkNode(this.mppQueryContext.getQueryId().genPlanNodeId());
            identitySinkNode.addChild(exchangeNode.getChild());
            identitySinkNode.addDownStreamChannelLocation(new DownStreamChannelLocation(exchangeNode.getPlanNodeId().toString()));
            exchangeNode.setChild(identitySinkNode);
            exchangeNode.setIndexOfUpstreamSinkHandle(identitySinkNode.getCurrentLastIndex());
        }
    }
}

