/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillPolicy;
import org.apache.tsfile.utils.TimeDuration;

public class Fill
extends Node {
    private final FillPolicy fillMethod;
    private final Literal fillValue;
    private final TimeDuration timeBound;
    private final LongLiteral timeColumnIndex;
    private final List<LongLiteral> fillGroupingElements;

    public Fill(NodeLocation location, Literal fillValue) {
        super(Objects.requireNonNull(location, "location is null"));
        this.fillValue = fillValue;
        this.timeBound = null;
        this.timeColumnIndex = null;
        this.fillMethod = FillPolicy.CONSTANT;
        this.fillGroupingElements = null;
    }

    public Fill(NodeLocation location, TimeDuration timeBound, LongLiteral timeColumnIndex, List<LongLiteral> fillGroupingElements) {
        super(Objects.requireNonNull(location, "location is null"));
        this.fillValue = null;
        this.timeBound = timeBound;
        this.timeColumnIndex = timeColumnIndex;
        this.fillMethod = FillPolicy.PREVIOUS;
        this.fillGroupingElements = fillGroupingElements;
    }

    public Fill(NodeLocation location, LongLiteral timeColumnIndex, List<LongLiteral> fillGroupingElements) {
        super(Objects.requireNonNull(location, "location is null"));
        this.fillValue = null;
        this.timeBound = null;
        this.timeColumnIndex = timeColumnIndex;
        this.fillMethod = FillPolicy.LINEAR;
        this.fillGroupingElements = fillGroupingElements;
    }

    public FillPolicy getFillMethod() {
        return this.fillMethod;
    }

    public Optional<Literal> getFillValue() {
        return Optional.ofNullable(this.fillValue);
    }

    public Optional<TimeDuration> getTimeBound() {
        return Optional.ofNullable(this.timeBound);
    }

    public Optional<LongLiteral> getTimeColumnIndex() {
        return Optional.ofNullable(this.timeColumnIndex);
    }

    public Optional<List<LongLiteral>> getFillGroupingElements() {
        return Optional.ofNullable(this.fillGroupingElements);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFill(this, context);
    }

    public List<Node> getChildren() {
        return this.fillValue != null ? ImmutableList.of((Object)this.fillValue) : ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fill fill = (Fill)o;
        return this.fillMethod == fill.fillMethod && Objects.equals(this.fillValue, fill.fillValue) && Objects.equals(this.timeBound, fill.timeBound) && Objects.equals(this.timeColumnIndex, fill.timeColumnIndex) && Objects.equals(this.fillGroupingElements, fill.fillGroupingElements);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fillMethod, this.fillValue, this.timeBound, this.timeColumnIndex, this.fillGroupingElements});
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this).add("fillMethod", (Object)this.fillMethod);
        if (this.fillValue != null) {
            stringHelper.add("value", (Object)this.fillValue);
        }
        if (this.timeBound != null) {
            stringHelper.add("TIME_BOUND", (Object)this.timeBound);
        }
        if (this.timeColumnIndex != null) {
            stringHelper.add("TIME_COLUMN", (Object)this.timeColumnIndex);
        }
        if (this.fillGroupingElements != null) {
            stringHelper.add("FILL_GROUP", this.fillGroupingElements);
        }
        return stringHelper.toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Fill fill = (Fill)other;
        return this.fillMethod == fill.fillMethod && Objects.equals(this.timeBound, fill.timeBound) && Objects.equals(this.timeColumnIndex, fill.timeColumnIndex) && Objects.equals(this.fillGroupingElements, fill.fillGroupingElements);
    }
}

