/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.response;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.rpc.subscription.config.TopicConfig;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseType;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeResp;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeSubscribeHeartbeatResp
extends TPipeSubscribeResp {
    private transient Map<String, TopicConfig> topics = new HashMap<String, TopicConfig>();
    private transient Map<Integer, TEndPoint> endPoints = new HashMap<Integer, TEndPoint>();
    private transient List<String> topicNamesToUnsubscribe = new ArrayList<String>();

    public Map<String, TopicConfig> getTopics() {
        return this.topics;
    }

    public Map<Integer, TEndPoint> getEndPoints() {
        return this.endPoints;
    }

    public List<String> getTopicNamesToUnsubscribe() {
        return this.topicNamesToUnsubscribe;
    }

    public static PipeSubscribeHeartbeatResp toTPipeSubscribeResp(TSStatus status) {
        PipeSubscribeHeartbeatResp resp = new PipeSubscribeHeartbeatResp();
        resp.status = status;
        resp.version = PipeSubscribeResponseVersion.VERSION_1.getVersion();
        resp.type = PipeSubscribeResponseType.ACK.getType();
        return resp;
    }

    public static PipeSubscribeHeartbeatResp toTPipeSubscribeResp(TSStatus status, Map<String, TopicConfig> topics, Map<Integer, TEndPoint> endPoints, List<String> topicNamesToUnsubscribe) throws IOException {
        PipeSubscribeHeartbeatResp resp = PipeSubscribeHeartbeatResp.toTPipeSubscribeResp(status);
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((int)topics.size(), (OutputStream)outputStream);
            for (Map.Entry<String, TopicConfig> entry : topics.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                entry.getValue().serialize(outputStream);
            }
            ReadWriteIOUtils.write((int)endPoints.size(), (OutputStream)outputStream);
            for (Map.Entry<Object, TopicConfig> entry : endPoints.entrySet()) {
                ReadWriteIOUtils.write((int)((Integer)entry.getKey()), (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)((TEndPoint)entry.getValue()).getIp(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((int)((TEndPoint)entry.getValue()).getPort(), (OutputStream)outputStream);
            }
            ReadWriteIOUtils.writeStringList(topicNamesToUnsubscribe, (OutputStream)outputStream);
            resp.body = Collections.singletonList(ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size()));
        }
        return resp;
    }

    public static PipeSubscribeHeartbeatResp fromTPipeSubscribeResp(TPipeSubscribeResp heartbeatResp) {
        PipeSubscribeHeartbeatResp resp = new PipeSubscribeHeartbeatResp();
        if (Objects.nonNull(heartbeatResp.body)) {
            for (ByteBuffer byteBuffer : heartbeatResp.body) {
                int i;
                if (!Objects.nonNull(byteBuffer) || !byteBuffer.hasRemaining()) continue;
                int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
                HashMap<String, TopicConfig> topics = new HashMap<String, TopicConfig>();
                for (i = 0; i < size; ++i) {
                    String topicName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
                    TopicConfig topicConfig = TopicConfig.deserialize(byteBuffer);
                    topics.put(topicName, topicConfig);
                }
                resp.topics = topics;
                size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
                HashMap<Integer, TEndPoint> endPoints = new HashMap<Integer, TEndPoint>();
                for (i = 0; i < size; ++i) {
                    int nodeId = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
                    String ip = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
                    int port = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
                    endPoints.put(nodeId, new TEndPoint(ip, port));
                }
                resp.endPoints = endPoints;
                resp.topicNamesToUnsubscribe = ReadWriteIOUtils.readStringList((ByteBuffer)byteBuffer);
                break;
            }
        }
        resp.status = heartbeatResp.status;
        resp.version = heartbeatResp.version;
        resp.type = heartbeatResp.type;
        resp.body = heartbeatResp.body;
        return resp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribeHeartbeatResp that = (PipeSubscribeHeartbeatResp)((Object)obj);
        return Objects.equals(this.topics, that.topics) && Objects.equals(this.endPoints, that.endPoints) && Objects.equals(this.topicNamesToUnsubscribe, that.topicNamesToUnsubscribe) && Objects.equals(this.status, that.status) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.topics, this.endPoints, this.topicNamesToUnsubscribe, this.status, this.version, this.type, this.body);
    }
}

