/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.List;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.utils.datastructure.BatchEncodeInfo;
import org.apache.iotdb.db.utils.datastructure.MultiTVListIterator;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.write.chunk.IChunkWriter;

public class OrderedMultiTVListIterator
extends MultiTVListIterator {
    public OrderedMultiTVListIterator(Ordering scanOrder, Filter globalTimeFilter, TSDataType tsDataType, List<TVList> tvLists, List<Integer> tvListRowCounts, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding, int maxNumberOfPointsInPage) {
        super(scanOrder, globalTimeFilter, tsDataType, tvLists, tvListRowCounts, deletionList, floatPrecision, encoding, maxNumberOfPointsInPage);
    }

    @Override
    protected void prepareNext() {
        this.hasNext = false;
        while (this.iteratorIndex < this.tvListIterators.size() && !this.hasNext) {
            TVList.TVListIterator iterator = (TVList.TVListIterator)this.tvListIterators.get(this.iteratorIndex);
            if (!iterator.hasNextTimeValuePair()) {
                ++this.iteratorIndex;
                continue;
            }
            this.rowIndex = iterator.getIndex();
            this.currentTime = iterator.currentTime();
            this.hasNext = true;
        }
        this.probeNext = true;
    }

    @Override
    protected void skipToCurrentTimeRangeStartPosition() {
        this.hasNext = false;
        this.iteratorIndex = 0;
        while (this.iteratorIndex < this.tvListIterators.size() && !this.hasNext) {
            TVList.TVListIterator iterator = (TVList.TVListIterator)this.tvListIterators.get(this.iteratorIndex);
            iterator.skipToCurrentTimeRangeStartPosition();
            if (!iterator.hasNextTimeValuePair()) {
                ++this.iteratorIndex;
                continue;
            }
            this.hasNext = iterator.hasNextTimeValuePair();
        }
        this.probeNext = false;
    }

    @Override
    protected void next() {
        ((TVList.TVListIterator)this.tvListIterators.get(this.iteratorIndex)).next();
        this.probeNext = false;
    }

    @Override
    public void encodeBatch(IChunkWriter chunkWriter, BatchEncodeInfo encodeInfo, long[] times) {
        while (this.iteratorIndex < this.tvListIterators.size()) {
            TVList.TVListIterator iterator = (TVList.TVListIterator)this.tvListIterators.get(this.iteratorIndex);
            if (!iterator.hasNextBatch()) {
                ++this.iteratorIndex;
                continue;
            }
            if (this.iteratorIndex == this.tvListIterators.size() - 1) {
                encodeInfo.lastIterator = true;
            }
            iterator.encodeBatch(chunkWriter, encodeInfo, times);
            break;
        }
        this.probeNext = false;
    }

    @Override
    public void setCurrentPageTimeRange(TimeRange timeRange) {
        for (TVList.TVListIterator tvListIterator : this.tvListIterators) {
            tvListIterator.timeRange = timeRange;
        }
        super.setCurrentPageTimeRange(timeRange);
    }
}

